/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterDL;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.UIExporterDLPanel;
import org.openide.util.NbBundle;

public class UIExporterDL
implements ExporterUI {
    private UIExporterDLPanel panel;
    private ExporterDL exporter;
    private ExporterDLSettings settings = new ExporterDLSettings();

    public JPanel getPanel() {
        this.panel = new UIExporterDLPanel();
        return this.panel;
    }

    public void setup(Exporter exporter) {
        this.exporter = (ExporterDL)exporter;
        this.settings.load(this.exporter);
        this.panel.setup(this.exporter);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporter);
            this.settings.save(this.exporter);
        }
        this.panel = null;
        this.exporter = null;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterDL;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterDL.class, (String)"UIExporterDL.name");
    }

    private static class ExporterDLSettings {
        private boolean useListFormat = true;
        private boolean useMatrixFormat = false;
        private boolean makeSymmetricMatrix = false;

        private ExporterDLSettings() {
        }

        private void load(ExporterDL exporterDL) {
            exporterDL.setUseListFormat(this.useListFormat);
            exporterDL.setUseMatrixFormat(this.useMatrixFormat);
            exporterDL.setMakeSymmetricMatrix(this.makeSymmetricMatrix);
        }

        private void save(ExporterDL exporterDL) {
            this.useListFormat = exporterDL.isUseListFormat();
            this.useMatrixFormat = exporterDL.isUseMatrixFormat();
            this.makeSymmetricMatrix = exporterDL.isMakeSymmetricMatrix();
        }
    }
}

