/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.opengl;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.gephi.visualization.VizController;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.apiimpl.Scheduler;
import org.gephi.visualization.model.Model;
import org.gephi.visualization.model.edge.EdgeModel;
import org.gephi.visualization.model.edge.EdgeModeler;
import org.gephi.visualization.model.node.NodeModel;
import org.gephi.visualization.model.node.NodeModeler;
import org.gephi.visualization.octree.Octree;
import org.gephi.visualization.opengl.AbstractEngine;
import org.gephi.visualization.scheduler.CompatibilityScheduler;
import org.gephi.visualization.selection.Cylinder;
import org.gephi.visualization.selection.Rectangle;

public class CompatibilityEngine
extends AbstractEngine {
    private CompatibilityScheduler scheduler;
    private int markTime = 0;
    private boolean anySelected = false;
    private List<NodeModel> dragSelected;

    @Override
    public void initArchitecture() {
        super.initArchitecture();
        this.scheduler = (CompatibilityScheduler)VizController.getInstance().getScheduler();
        this.vizEventManager = VizController.getInstance().getVizEventManager();
        this.octree = new Octree(this.vizConfig.getOctreeDepth(), this.vizConfig.getOctreeWidth());
        this.octree.initArchitecture();
    }

    public synchronized void updateSelection(GL2 gl, GLU glu) {
        if (this.vizConfig.isSelectionEnable() && this.currentSelectionArea != null && this.currentSelectionArea.isEnabled()) {
            float[] mp = Arrays.copyOf(this.graphIO.getMousePosition(), 2);
            float[] cent = this.currentSelectionArea.getSelectionAreaCenter();
            if (cent != null) {
                mp[0] = mp[0] + cent[0];
                mp[1] = mp[1] + cent[1];
            }
            this.octree.updateSelectedOctant(gl, glu, mp, this.currentSelectionArea.getSelectionAreaRectancle());
        }
    }

    @Override
    public synchronized boolean updateWorld() {
        boolean repositioned = this.octree.repositionNodes();
        boolean updated = this.dataBridge.updateWorld();
        return repositioned || updated;
    }

    @Override
    public void beforeDisplay(GL2 gl, GLU glu) {
        if (this.lightenAnimationDelta != 0.0f) {
            float factor = this.vizConfig.getLightenNonSelectedFactor();
            if ((factor += this.lightenAnimationDelta) >= 0.5f && factor <= 0.98f) {
                this.vizConfig.setLightenNonSelectedFactor(factor);
            } else {
                this.lightenAnimationDelta = 0.0f;
                this.vizConfig.setLightenNonSelected(this.anySelected);
            }
        }
        if (this.backgroundChanged) {
            float[] backgroundColor = this.vizController.getVizModel().getBackgroundColorComponents();
            gl.glClearColor(backgroundColor[0], backgroundColor[1], backgroundColor[2], 1.0f);
            gl.glClear(16384);
            this.backgroundChanged = false;
        }
        if (this.reinit) {
            VizController.getInstance().refreshWorkspace();
            this.dataBridge.reset();
            this.graphDrawable.initConfig(gl);
            this.graphDrawable.setCameraLocation(this.vizController.getVizModel().getCameraPosition());
            this.graphDrawable.setCameraTarget(this.vizController.getVizModel().getCameraTarget());
            this.vizConfig.setCustomSelection(false);
            this.reinit = false;
        }
    }

    @Override
    public synchronized void display(GL2 gl, GLU glu) {
        Model obj;
        Iterator<Model> itr;
        ++this.markTime;
        VizModel vizModel = VizController.getInstance().getVizModel();
        if (this.edgeModeler.isEnabled()) {
            this.edgeModeler.beforeDisplay(gl, glu);
            itr = this.octree.getEdgeIterator();
            while (itr.hasNext()) {
                obj = itr.next();
                if (((EdgeModel)obj).markTime == this.markTime) continue;
                obj.display(gl, glu, vizModel);
                ((EdgeModel)obj).markTime = this.markTime;
            }
            this.edgeModeler.afterDisplay(gl, glu);
        }
        ++this.markTime;
        if (this.edgeModeler.isEnabled() && this.vizConfig.isShowArrows() && this.dataBridge.isDirected()) {
            gl.glBegin(4);
            itr = this.octree.getEdgeIterator();
            while (itr.hasNext()) {
                obj = (EdgeModel)itr.next();
                if (!((EdgeModel)obj).getEdge().isDirected() || ((EdgeModel)obj).markTime == this.markTime) continue;
                ((EdgeModel)obj).displayArrow(gl, glu, vizModel);
                ((EdgeModel)obj).markTime = this.markTime;
            }
            gl.glEnd();
        }
        if (this.nodeModeler.isEnabled()) {
            this.nodeModeler.beforeDisplay(gl, glu);
            itr = this.octree.getNodeIterator();
            while (itr.hasNext()) {
                obj = (NodeModel)itr.next();
                if (((NodeModel)obj).markTime == this.markTime) continue;
                obj.display(gl, glu, vizModel);
                ((NodeModel)obj).markTime = this.markTime;
            }
            this.nodeModeler.afterDisplay(gl, glu);
        }
        if (vizModel.getTextModel().isShowNodeLabels() || vizModel.getTextModel().isShowEdgeLabels()) {
            ++this.markTime;
            if (this.nodeModeler.isEnabled() && vizModel.getTextModel().isShowNodeLabels()) {
                this.textManager.getNodeRenderer().beginRendering();
                this.textManager.defaultNodeColor();
                if (this.textManager.isSelectedOnly()) {
                    itr = this.octree.getNodeIterator();
                    while (itr.hasNext()) {
                        obj = (NodeModel)itr.next();
                        if (((NodeModel)obj).markTime == this.markTime) continue;
                        if (((NodeModel)obj).isSelected() && ((NodeModel)obj).isTextVisible()) {
                            this.textManager.getNodeRenderer().drawTextNode((NodeModel)obj);
                        }
                        ((NodeModel)obj).markTime = this.markTime;
                    }
                } else {
                    itr = this.octree.getNodeIterator();
                    while (itr.hasNext()) {
                        obj = (NodeModel)itr.next();
                        if (((NodeModel)obj).markTime == this.markTime) continue;
                        if (((NodeModel)obj).isTextVisible()) {
                            this.textManager.getNodeRenderer().drawTextNode((NodeModel)obj);
                        }
                        ((NodeModel)obj).markTime = this.markTime;
                    }
                }
                this.textManager.getNodeRenderer().endRendering();
            }
            if (this.edgeModeler.isEnabled() && vizModel.getTextModel().isShowEdgeLabels()) {
                ++this.markTime;
                this.textManager.getEdgeRenderer().beginRendering();
                this.textManager.defaultEdgeColor();
                if (this.textManager.isSelectedOnly()) {
                    itr = this.octree.getEdgeIterator();
                    while (itr.hasNext()) {
                        obj = (EdgeModel)itr.next();
                        if (((EdgeModel)obj).markTime == this.markTime) continue;
                        if ((((EdgeModel)obj).isSelected() || ((EdgeModel)obj).isAutoSelected()) && ((EdgeModel)obj).isTextVisible()) {
                            this.textManager.getEdgeRenderer().drawTextEdge((EdgeModel)obj);
                        }
                        ((EdgeModel)obj).markTime = this.markTime;
                    }
                } else {
                    itr = this.octree.getEdgeIterator();
                    while (itr.hasNext()) {
                        obj = (EdgeModel)itr.next();
                        if (((EdgeModel)obj).markTime == this.markTime) continue;
                        if (((EdgeModel)obj).isTextVisible()) {
                            this.textManager.getEdgeRenderer().drawTextEdge((EdgeModel)obj);
                        }
                        ((EdgeModel)obj).markTime = this.markTime;
                    }
                }
                this.textManager.getEdgeRenderer().endRendering();
            }
        }
    }

    @Override
    public void afterDisplay(GL2 gl, GLU glu) {
        if (this.vizConfig.isSelectionEnable() && this.currentSelectionArea != null) {
            gl.glMatrixMode(5889);
            gl.glPushMatrix();
            gl.glLoadIdentity();
            gl.glOrtho(0.0, (double)this.graphDrawable.getViewportWidth(), 0.0, (double)this.graphDrawable.getViewportHeight(), -1.0, 1.0);
            gl.glMatrixMode(5888);
            gl.glPushMatrix();
            gl.glLoadIdentity();
            this.currentSelectionArea.drawArea(gl, glu);
            gl.glMatrixMode(5889);
            gl.glPopMatrix();
            gl.glMatrixMode(5888);
            gl.glPopMatrix();
        }
        this.graphIO.trigger();
    }

    @Override
    public void cameraHasBeenMoved(GL2 gl, GLU glu) {
    }

    @Override
    public void initEngine(GL2 gl, GLU glu) {
        this.initDisplayLists(gl, glu);
        this.lifeCycle.setInited();
    }

    @Override
    public synchronized void mouseClick() {
        if (this.vizConfig.isSelectionEnable() && this.rectangleSelection && !this.customSelection) {
            Rectangle rectangle = (Rectangle)this.currentSelectionArea;
            this.resetEdgesSelection();
            boolean someSelection = false;
            Iterator<NodeModel> itr = this.octree.getSelectableNodeIterator();
            while (itr.hasNext()) {
                NodeModel obj = itr.next();
                if (this.isUnderMouse(obj)) {
                    if (!obj.isSelected()) {
                        obj.setSelected(true);
                    }
                    someSelection = true;
                    continue;
                }
                if (!obj.isSelected()) continue;
                someSelection = true;
            }
            if (!rectangle.isCtrl() || !someSelection) {
                for (NodeModel nm : this.getSelectedNodes()) {
                    nm.setSelected(false);
                }
                someSelection = false;
            }
            rectangle.setBlocking(someSelection);
            if (this.vizController.getVizModel().isLightenNonSelectedAuto()) {
                if (this.vizConfig.isLightenNonSelectedAnimation()) {
                    if (!this.anySelected && someSelection) {
                        this.lightenAnimationDelta = 0.07f;
                    } else if (this.anySelected && !someSelection) {
                        this.lightenAnimationDelta = -0.07f;
                    }
                    this.vizConfig.setLightenNonSelected(someSelection || this.lightenAnimationDelta != 0.0f);
                } else {
                    this.vizConfig.setLightenNonSelected(someSelection);
                }
            }
            this.anySelected = someSelection;
            this.scheduler.requireUpdateSelection();
        }
    }

    @Override
    public void mouseDrag() {
        if (this.vizConfig.isMouseSelectionUpdateWhileDragging()) {
            this.mouseMove();
        } else {
            float[] drag = this.graphIO.getMouseDrag3d();
            if (this.dragSelected != null) {
                for (NodeModel obj : this.dragSelected) {
                    float[] mouseDistance = obj.getDragDistanceFromMouse();
                    obj.getNode().setX(drag[0] + mouseDistance[0]);
                    obj.getNode().setY(drag[1] + mouseDistance[1]);
                }
            }
        }
    }

    @Override
    public synchronized void mouseMove() {
        if (this.vizConfig.isSelectionEnable() && this.rectangleSelection) {
            Rectangle rectangle = (Rectangle)this.currentSelectionArea;
            rectangle.setMousePosition(this.graphIO.getMousePosition(), this.graphIO.getMousePosition3d());
            if (rectangle.isStop()) {
                return;
            }
        }
        if (this.customSelection || this.currentSelectionArea != null && this.currentSelectionArea.blockSelection()) {
            return;
        }
        if (!this.rectangleSelection && this.graphIO.isDragging()) {
            return;
        }
        boolean someSelection = false;
        Iterator<NodeModel> itr = this.octree.getSelectableNodeIterator();
        while (itr.hasNext()) {
            NodeModel obj = itr.next();
            if (this.isUnderMouse(obj)) {
                if (!obj.isSelected()) {
                    obj.setSelected(true);
                }
                someSelection = true;
                continue;
            }
            if (!obj.isSelected()) continue;
            obj.setSelected(false);
        }
        if (this.vizController.getVizModel().isLightenNonSelectedAuto()) {
            if (this.vizConfig.isLightenNonSelectedAnimation()) {
                if (!this.anySelected && someSelection) {
                    this.lightenAnimationDelta = 0.07f;
                } else if (this.anySelected && !someSelection) {
                    this.lightenAnimationDelta = -0.07f;
                }
                this.vizConfig.setLightenNonSelected(someSelection || this.lightenAnimationDelta != 0.0f);
            } else {
                this.vizConfig.setLightenNonSelected(someSelection);
            }
        }
        this.anySelected = someSelection;
    }

    @Override
    public void refreshGraphLimits() {
    }

    @Override
    public void startDrag() {
        float x = this.graphIO.getMouseDrag3d()[0];
        float y = this.graphIO.getMouseDrag3d()[1];
        this.dragSelected = this.getSelectedNodes();
        for (NodeModel selected : this.dragSelected) {
            float[] tab = selected.getDragDistanceFromMouse();
            tab[0] = selected.getNode().x() - x;
            tab[1] = selected.getNode().y() - y;
        }
    }

    @Override
    public void stopDrag() {
        if (this.vizConfig.isSelectionEnable() && this.rectangleSelection) {
            Rectangle rectangle = (Rectangle)this.currentSelectionArea;
            rectangle.stop();
            this.scheduler.requireUpdateSelection();
        }
        this.dragSelected = null;
    }

    @Override
    public synchronized void updateLOD() {
        Iterator<NodeModel> iterator = this.octree.getNodeIterator();
        while (iterator.hasNext()) {
            NodeModel obj = iterator.next();
            this.nodeModeler.chooseModel(obj);
        }
    }

    @Override
    public synchronized List<NodeModel> getSelectedNodes() {
        ArrayList<NodeModel> selected = new ArrayList<NodeModel>();
        Iterator<NodeModel> itr = this.octree.getNodeIterator();
        while (itr.hasNext()) {
            NodeModel nodeModel = itr.next();
            if (!nodeModel.isSelected()) continue;
            selected.add(nodeModel);
        }
        return selected;
    }

    @Override
    public synchronized List<EdgeModel> getSelectedEdges() {
        ArrayList<EdgeModel> selected = new ArrayList<EdgeModel>();
        Iterator<EdgeModel> itr = this.octree.getEdgeIterator();
        while (itr.hasNext()) {
            EdgeModel edgeModel = itr.next();
            if (!edgeModel.isSelected()) continue;
            selected.add(edgeModel);
        }
        return selected;
    }

    @Override
    public synchronized List<Node> getSelectedUnderlyingNodes() {
        ArrayList<Node> selected = new ArrayList<Node>();
        Iterator<NodeModel> itr = this.octree.getNodeIterator();
        while (itr.hasNext()) {
            NodeModel nodeModel = itr.next();
            if (!nodeModel.isSelected()) continue;
            selected.add(nodeModel.getNode());
        }
        return selected;
    }

    @Override
    public synchronized List<Edge> getSelectedUnderlyingEdges() {
        ArrayList<Edge> selected = new ArrayList<Edge>();
        Iterator<EdgeModel> itr = this.octree.getEdgeIterator();
        while (itr.hasNext()) {
            EdgeModel edgeModel = itr.next();
            if (!edgeModel.isSelected()) continue;
            selected.add(edgeModel.getEdge());
        }
        return selected;
    }

    @Override
    public void selectObject(Model modl) {
        this.selectObject(new Model[]{modl});
    }

    @Override
    public void selectObject(Model[] objs) {
        if (!this.customSelection) {
            this.vizConfig.setRectangleSelection(false);
            this.customSelection = true;
        }
        if (objs != null) {
            for (Model mdl : objs) {
                if (mdl == null) continue;
                mdl.setSelected(true);
                this.anySelected = true;
            }
            this.forceHighlight();
        }
        this.scheduler.requireUpdateSelection();
        this.configChanged = true;
    }

    private void forceHighlight() {
        if (this.vizController.getVizModel().isLightenNonSelectedAuto()) {
            if (this.vizConfig.isLightenNonSelectedAnimation()) {
                this.lightenAnimationDelta = 0.07f;
                this.vizConfig.setLightenNonSelected(true);
            } else {
                this.vizConfig.setLightenNonSelected(true);
            }
        }
    }

    @Override
    public synchronized void resetSelection() {
        this.resetNodesSelection();
        this.resetEdgesSelection();
        this.customSelection = false;
        this.configChanged = true;
        this.anySelected = false;
        this.vizConfig.setLightenNonSelected(false);
        this.scheduler.requireUpdateSelection();
    }

    private void resetNodesSelection() {
        for (NodeModel selectedNode : this.getSelectedNodes()) {
            selectedNode.setSelected(false);
        }
    }

    private void resetEdgesSelection() {
        for (EdgeModel selectedEdge : this.getSelectedEdges()) {
            selectedEdge.setSelected(false);
        }
    }

    @Override
    public void initDisplayLists(GL2 gl, GLU glu) {
        GLUquadric quadric = glu.gluNewQuadric();
        int ptr = gl.glGenLists(4);
        this.nodeModeler.initDisplayLists(gl, glu, quadric, ptr);
        glu.gluDeleteQuadric(quadric);
    }

    @Override
    public void initObject3dClass() {
        this.nodeModeler = new NodeModeler(this);
        this.edgeModeler = new EdgeModeler(this);
        this.nodeModeler.setEnabled(true);
        this.edgeModeler.setEnabled(this.vizController.getVizModel().isShowEdges());
    }

    @Override
    public void initSelection() {
        if (this.vizConfig.isCustomSelection()) {
            this.rectangleSelection = false;
            this.currentSelectionArea = null;
            this.customSelection = true;
        } else if (this.vizConfig.isRectangleSelection()) {
            this.currentSelectionArea = new Rectangle();
            this.rectangleSelection = true;
            this.customSelection = false;
        } else {
            this.currentSelectionArea = new Cylinder();
            this.rectangleSelection = false;
            this.customSelection = false;
        }
    }

    @Override
    public void startAnimating() {
        if (!this.scheduler.isAnimating()) {
            this.scheduler.start();
            this.graphIO.startMouseListening();
        }
    }

    @Override
    public void stopAnimating() {
        if (this.scheduler.isAnimating()) {
            this.scheduler.stop();
            this.graphIO.stopMouseListening();
        }
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

