/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.appearance.plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import net.java.dev.colorchooser.ColorChooser;
import org.gephi.appearance.api.SimpleFunction;
import org.gephi.appearance.plugin.AbstractUniqueColorTransformer;
import org.openide.util.NbBundle;

public class UniqueColorTransformerPanel
extends JPanel {
    private AbstractUniqueColorTransformer transformer;
    private ColorChooser colorChooser;
    private JLabel colorLabel;

    public UniqueColorTransformerPanel() {
        this.initComponents();
        this.colorChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("color") && !UniqueColorTransformerPanel.this.transformer.getColor().equals(UniqueColorTransformerPanel.this.colorChooser.getColor())) {
                    UniqueColorTransformerPanel.this.transformer.setColor(UniqueColorTransformerPanel.this.colorChooser.getColor());
                    UniqueColorTransformerPanel.this.colorLabel.setText(UniqueColorTransformerPanel.this.getHex(UniqueColorTransformerPanel.this.colorChooser.getColor()));
                }
            }
        });
    }

    public void setup(SimpleFunction function) {
        this.transformer = (AbstractUniqueColorTransformer)function.getTransformer();
        this.colorChooser.setColor(this.transformer.getColor());
        this.colorLabel.setText(this.getHex(this.transformer.getColor()));
    }

    private String getHex(Color color) {
        return "#" + String.format("%06x", color.getRGB() & 0xFFFFFF);
    }

    private void initComponents() {
        this.colorChooser = new ColorChooser();
        this.colorLabel = new JLabel();
        this.colorChooser.setMinimumSize(new Dimension(14, 14));
        this.colorChooser.setPreferredSize(new Dimension(14, 14));
        this.colorChooser.setToolTipText(NbBundle.getMessage(UniqueColorTransformerPanel.class, (String)"UniqueColorTransformerPanel.colorChooser.toolTipText"));
        GroupLayout colorChooserLayout = new GroupLayout((Container)this.colorChooser);
        this.colorChooser.setLayout((LayoutManager)colorChooserLayout);
        colorChooserLayout.setHorizontalGroup(colorChooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        colorChooserLayout.setVerticalGroup(colorChooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent((Component)this.colorChooser, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorLabel, -2, 380, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colorLabel).addComponent((Component)this.colorChooser, -2, -1, -2)).addGap(278, 278, 278)));
    }
}

