/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters.query;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.Action;
import org.gephi.desktop.filters.library.FilterBuilderNode;
import org.gephi.desktop.filters.query.QueryNode;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.Query;
import org.gephi.filters.spi.FilterBuilder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class SlotNode
extends AbstractNode {
    private Query parent;

    public SlotNode(Query parent) {
        super(Children.LEAF);
        this.parent = parent;
        this.setIconBaseWithExtension("org/gephi/desktop/filters/query/resources/drop.png");
        this.setShortDescription(NbBundle.getMessage(SlotNode.class, (String)"SlotNode.description"));
    }

    public String getHtmlDisplayName() {
        return NbBundle.getMessage(SlotNode.class, (String)"SlotNode.name");
    }

    public Action[] getActions(boolean context) {
        return new Action[0];
    }

    public PasteType getDropType(final Transferable t, int action, int index) {
        final Node dropNode = NodeTransfer.node((Transferable)t, (int)3);
        if (dropNode != null && dropNode instanceof QueryNode) {
            Query q = ((QueryNode)dropNode).getQuery();
            if (!Arrays.asList(q.getDescendantsAndSelf()).contains(this.parent)) {
                return new PasteType(){

                    public Transferable paste() throws IOException {
                        QueryNode queryNode = (QueryNode)dropNode;
                        FilterController filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                        filterController.setSubQuery(SlotNode.this.parent, queryNode.getQuery());
                        return null;
                    }
                };
            }
        } else if (t.isDataFlavorSupported(FilterBuilderNode.DATA_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        FilterBuilder builder = (FilterBuilder)t.getTransferData(FilterBuilderNode.DATA_FLAVOR);
                        FilterController filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                        Query query = filterController.createQuery(builder);
                        filterController.setSubQuery(SlotNode.this.parent, query);
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        return null;
    }
}

