/*
 * Decompiled with CFR 0.152.
 */
package com.getsentry.raven.event.helper;

import com.getsentry.raven.Raven;
import com.getsentry.raven.context.Context;
import com.getsentry.raven.event.Breadcrumb;
import com.getsentry.raven.event.EventBuilder;
import com.getsentry.raven.event.User;
import com.getsentry.raven.event.helper.EventBuilderHelper;
import com.getsentry.raven.event.interfaces.UserInterface;
import java.util.ArrayList;
import java.util.Iterator;

public class ContextBuilderHelper
implements EventBuilderHelper {
    private Raven raven;

    public ContextBuilderHelper(Raven raven) {
        this.raven = raven;
    }

    @Override
    public void helpBuildingEvent(EventBuilder eventBuilder) {
        ArrayList<Breadcrumb> breadcrumbs = new ArrayList<Breadcrumb>();
        Context context = this.raven.getContext();
        Iterator<Breadcrumb> breadcrumbIterator = context.getBreadcrumbs();
        while (breadcrumbIterator.hasNext()) {
            breadcrumbs.add(breadcrumbIterator.next());
        }
        if (!breadcrumbs.isEmpty()) {
            eventBuilder.withBreadcrumbs(breadcrumbs);
        }
        if (context.getUser() != null) {
            eventBuilder.withSentryInterface(this.fromUser(context.getUser()));
        }
    }

    private UserInterface fromUser(User user) {
        return new UserInterface(user.getId(), user.getUsername(), user.getIpAddress(), user.getEmail());
    }
}

