/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.utils;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class ButtonSizingUtils {
    private static ButtonSizingUtils instance;
    private Insets outsets = this.syncOutsets(new JButton(""));
    private Insets toggleOutsets = this.syncOutsets(new JToggleButton(""));

    public static synchronized ButtonSizingUtils getInstance() {
        if (instance == null) {
            instance = new ButtonSizingUtils();
        }
        return instance;
    }

    private ButtonSizingUtils() {
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("lookAndFeel".equals(evt.getPropertyName())) {
                    ButtonSizingUtils.this.outsets = ButtonSizingUtils.this.syncOutsets(new JButton(""));
                    ButtonSizingUtils.this.toggleOutsets = ButtonSizingUtils.this.syncOutsets(new JToggleButton(""));
                }
            }
        });
    }

    private Insets syncOutsets(AbstractButton renderer) {
        JPanel panel = new JPanel(null);
        renderer.putClientProperty("JButton.buttonStyle", "square");
        renderer.setFocusable(false);
        renderer.setOpaque(false);
        panel.add(renderer);
        renderer.setBounds(0, 0, 100, 50);
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        BufferedImage compatibleImage = c.createCompatibleImage(100, 50, 3);
        renderer.paint(compatibleImage.getGraphics());
        int top = 0;
        for (int i = 0; i < 25; ++i) {
            int rgba = compatibleImage.getRGB(50, i);
            int alpha = rgba >>> 24 & 0xFF;
            if (alpha != 255) continue;
            top = i;
            break;
        }
        int bottom = 0;
        for (int i = 49; i > 25; --i) {
            int rgba = compatibleImage.getRGB(50, i);
            int alpha = rgba >>> 24 & 0xFF;
            if (alpha != 255) continue;
            bottom = 49 - i;
            break;
        }
        int left = 0;
        for (int i = 0; i < 50; ++i) {
            int rgba = compatibleImage.getRGB(i, 25);
            int alpha = rgba >>> 24 & 0xFF;
            if (alpha != 255) continue;
            left = i;
            break;
        }
        int right = 0;
        for (int i = 99; i > 50; --i) {
            int rgba = compatibleImage.getRGB(i, 25);
            int alpha = rgba >>> 24 & 0xFF;
            if (alpha != 255) continue;
            right = 99 - i;
            break;
        }
        return new Insets(top, left, bottom, right);
    }

    public Insets getOutsets() {
        return new Insets(this.outsets.top, this.outsets.left, this.outsets.bottom, this.outsets.right);
    }

    public Insets getToggleOutsets() {
        return new Insets(this.toggleOutsets.top, this.toggleOutsets.left, this.toggleOutsets.bottom, this.toggleOutsets.right);
    }
}

