/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.synth;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthConstants;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.plaf.basic.core.BasicXListUI;
import org.jdesktop.swingx.plaf.synth.SynthBorder;
import org.jdesktop.swingx.plaf.synth.SynthUI;
import org.jdesktop.swingx.plaf.synth.SynthUtils;
import org.jdesktop.swingx.plaf.synth.XRegion;

public class SynthXListUI
extends BasicXListUI
implements SynthConstants,
SynthUI {
    private SynthStyle style;
    private boolean useListColors;
    private boolean useUIBorder;

    public static ComponentUI createUI(JComponent list) {
        return new SynthXListUI();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthUtils.update(context, g);
        this.paintBorder(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(g, c);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        BasicXListUI.PropertyChangeHandler l = new BasicXListUI.PropertyChangeHandler(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (SynthUtils.shouldUpdateStyle(e)) {
                    SynthXListUI.this.updateStyle();
                }
                super.propertyChange(e);
            }
        };
        return l;
    }

    @Override
    protected void installDefaults() {
        this.updateStyle();
    }

    private void updateStyle() {
        int height;
        Color sfg;
        boolean refresh;
        if (this.style == this.getStyle()) {
            return;
        }
        boolean bl = refresh = this.style != null;
        if (refresh) {
            this.style.uninstallDefaults(this.getContext(1));
        }
        this.style = this.getStyle();
        this.installSynthBorder();
        this.style.installDefaults(this.getContext(1));
        SynthContext selectedContext = this.getContext(512);
        Color sbg = this.list.getSelectionBackground();
        if (sbg == null || sbg instanceof UIResource) {
            this.list.setSelectionBackground(this.style.getColor(selectedContext, ColorType.TEXT_BACKGROUND));
        }
        if ((sfg = this.list.getSelectionForeground()) == null || sfg instanceof UIResource) {
            this.list.setSelectionForeground(this.style.getColor(selectedContext, ColorType.TEXT_FOREGROUND));
        }
        if ((height = this.style.getInt(selectedContext, "List.cellHeight", -1)) != -1) {
            this.list.setFixedCellHeight(height);
        }
        if (refresh) {
            this.uninstallKeyboardActions();
            this.installKeyboardActions();
        }
        this.useListColors = this.style.getBoolean(selectedContext, "List.rendererUseListColors", true);
        this.useUIBorder = this.style.getBoolean(selectedContext, "List.rendererUseUIBorder", true);
    }

    protected void installSynthBorder() {
        if (SwingXUtilities.isUIInstallable(this.list.getBorder())) {
            this.list.setBorder(new SynthBorder(this, this.style.getInsets(this.getContext(1), null)));
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.style.uninstallDefaults(this.getContext(1));
        this.style = null;
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        SynthUtils.getPainter(context).paintListBorder(context, g, x, y, w, h);
    }

    @Override
    public SynthContext getContext(JComponent c) {
        if (c != this.list) {
            throw new IllegalArgumentException("must be ui-delegate for component");
        }
        return this.getContext();
    }

    private SynthContext getContext() {
        return this.getContext(this.getComponentState());
    }

    private int getComponentState() {
        return SynthUtils.getComponentState(this.list);
    }

    private SynthContext getContext(int state) {
        return SynthUtils.getContext(this.list, this.getRegion(), this.style, state);
    }

    private Region getRegion() {
        return XRegion.getXRegion(this.list, true);
    }

    private SynthStyle getStyle() {
        return SynthLookAndFeel.getStyleFactory().getStyle(this.list, this.getRegion());
    }
}

