/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;

public class TripleStateCheckBox
extends JCheckBox
implements ItemListener {
    private ImageIcon[] _icons = new ImageIcon[3];
    private int _currState = 0;

    public TripleStateCheckBox() {
        this.addItemListener(this);
    }

    public void setCurrentState(int n) {
        this._currState = n % 3;
        this.setIcon(this._icons[this._currState]);
        this.setSelected(false);
        this.setSelectedIcon(this._icons[(this._currState + 1) % 3]);
    }

    public int getCurrentState() {
        return this._currState;
    }

    public void setIcon(int n, ImageIcon imageIcon) {
        this._icons[n % 3] = imageIcon;
    }

    public void addItemListener(ItemListener itemListener) {
        super.addItemListener(new ProxyListener(itemListener));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setCurrentState(this._currState + 1);
    }

    private class ProxyListener
    implements ItemListener {
        private ItemListener _listener = null;

        ProxyListener(ItemListener itemListener) {
            this._listener = itemListener;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                this._listener.itemStateChanged(itemEvent);
            }
        }
    }
}

