/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.profile;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import tim.prune.I18nManager;
import tim.prune.config.ColourScheme;
import tim.prune.config.Config;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.TrackInfo;
import tim.prune.gui.GenericDisplay;
import tim.prune.gui.profile.AltitudeData;
import tim.prune.gui.profile.ArbitraryData;
import tim.prune.gui.profile.ProfileData;
import tim.prune.gui.profile.SpeedData;
import tim.prune.gui.profile.VerticalSpeedData;

public class ProfileChart
extends GenericDisplay
implements MouseListener {
    private double _xScaleFactor = 0.0;
    private ProfileData _data = null;
    private JLabel _label = null;
    private JPopupMenu _popup = null;
    private static final int[] LINE_SCALES = new int[]{10000, 5000, 2000, 1000, 500, 200, 100, 50, 10, 5, 2, 1};
    private static final int BORDER_WIDTH = 6;
    private static final Dimension MINIMUM_SIZE = new Dimension(200, 110);
    private static final Color COLOR_NODATA_TEXT = Color.GRAY;

    public ProfileChart(TrackInfo trackInfo) {
        super(trackInfo);
        this._data = new AltitudeData(trackInfo.getTrack());
        this.addMouseListener(this);
        this.setLayout(new FlowLayout(0));
        this._label = new JLabel("Altitude");
        this.add(this._label);
        this.makePopup();
    }

    public Dimension getMinimumSize() {
        return MINIMUM_SIZE;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, Config.getConfigBoolean("prune.antialias") ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        ColourScheme colourScheme = Config.getColourScheme();
        this.paintBackground(graphics, colourScheme);
        if (this._track != null && this._track.getNumPoints() > 0) {
            int n;
            this._label.setText(this._data.getLabel());
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            Color color = colourScheme.getColour(1);
            Color color2 = colourScheme.getColour(2);
            Color color3 = colourScheme.getColour(4);
            Color color4 = colourScheme.getColour(5);
            Color color5 = colourScheme.getColour(7);
            if (!this._data.hasData()) {
                graphics.setColor(color5);
                graphics.drawString(I18nManager.getText(this._data.getNoDataKey()), 50, (n3 + this._label.getHeight()) / 2);
                this.paintChildren(graphics);
                return;
            }
            double d = this._data.getMinValue();
            double d2 = this._data.getMaxValue();
            if (d2 <= d) {
                d2 = d + 1.0;
                d -= 1.0;
            }
            int n4 = this._track.getNumPoints();
            this._xScaleFactor = 1.0 * (double)(n2 - 12 - 1) / (double)n4;
            int n5 = n3 - 12 - this._label.getHeight();
            double d3 = 1.0 * (double)n5 / (d2 - d);
            int n6 = (int)(this._xScaleFactor + 1.0);
            int n7 = this._trackInfo.getSelection().getCurrentPointIndex();
            int n8 = -1;
            int n9 = -1;
            if (this._trackInfo.getSelection().hasRangeSelected()) {
                n8 = this._trackInfo.getSelection().getStart();
                n9 = this._trackInfo.getSelection().getEnd();
            }
            int n10 = this.getLineScale(d, d2);
            double d4 = Math.ceil(d / (double)n10) * (double)n10;
            int n11 = 0;
            int n12 = 0;
            int n13 = n3 - 6 - (int)(d3 * (0.0 - d));
            double d5 = 0.0;
            graphics.setColor(color5);
            if (n10 >= 1) {
                while (d4 < d2) {
                    n12 = n3 - 6 - (int)(d3 * (d4 - d));
                    graphics.drawLine(7, n12, n2 - 6 - 1, n12);
                    d4 += (double)n10;
                }
            } else if (d < 0.0) {
                n12 = n13;
                graphics.drawLine(7, n12, n2 - 6 - 1, n12);
            }
            try {
                graphics.setColor(color);
                n = 0;
                while (n < n4) {
                    n11 = (int)(this._xScaleFactor * (double)n) + 1;
                    if (n == n8) {
                        graphics.setColor(color2);
                    } else if (n == n9 + 1) {
                        graphics.setColor(color);
                    }
                    if (this._data.hasData(n)) {
                        d5 = this._data.getData(n);
                        if (d >= 0.0) {
                            n12 = (int)(d3 * (d5 - d));
                            graphics.fillRect(6 + n11, n3 - 6 - n12, n6, n12);
                        } else if (d5 >= 0.0) {
                            n12 = n3 - 6 - (int)(d3 * (d5 - d));
                            graphics.fillRect(6 + n11, n12, n6, n13 - n12);
                        } else {
                            int n14 = (int)(d3 * d5);
                            graphics.fillRect(6 + n11, n13, n6, -n14);
                        }
                    }
                    ++n;
                }
                if (n7 >= 0) {
                    n11 = (int)(this._xScaleFactor * (double)n7) + 1;
                    graphics.setColor(color4);
                    graphics.fillRect(6 + n11, n3 - n5 - 6 + 1, n6, n5 - 2);
                    if (this._data.hasData(n7)) {
                        graphics.setColor(color3);
                        d5 = this._data.getData(n7);
                        n12 = (int)(d3 * (d5 - d));
                        graphics.fillRect(6 + n11, n3 - 6 - n12, n6, n12);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {}
            if (n10 >= 1) {
                n = graphics.getFontMetrics().getHeight();
                d4 = (int)(d / (double)n10 + 1.0) * n10;
                if (d < 0.0) {
                    d4 -= (double)n10;
                }
                n12 = 0;
                graphics.setColor(color3);
                while (d4 < d2) {
                    n12 = n3 - 6 - (int)(d3 * (d4 - d));
                    if (n12 < 6 + n) {
                        n12 = 6 + n;
                    }
                    graphics.drawString("" + (int)d4, 11, n12);
                    d4 += (double)n10;
                }
            }
            this.paintChildren(graphics);
        }
    }

    private void paintBackground(Graphics graphics, ColourScheme colourScheme) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = colourScheme.getColour(6);
        Color color2 = colourScheme.getColour(0);
        graphics.setColor(color2);
        graphics.fillRect(0, 0, n, n2);
        if (n < 12 || n2 < 12) {
            return;
        }
        if (this._track == null || this._track.getNumPoints() <= 0) {
            graphics.setColor(COLOR_NODATA_TEXT);
            graphics.drawString(I18nManager.getText("display.nodata"), 50, n2 / 2);
        } else {
            graphics.setColor(color);
            graphics.drawRect(6, 6 + this._label.getHeight(), n - 12, n2 - 12 - this._label.getHeight());
        }
    }

    private synchronized void makePopup() {
        this._popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(I18nManager.getText("fieldname.altitude"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileChart.this.changeView(Field.ALTITUDE);
            }
        });
        this._popup.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(I18nManager.getText("fieldname.speed"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileChart.this.changeView(Field.SPEED);
            }
        });
        this._popup.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(I18nManager.getText("fieldname.verticalspeed"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileChart.this.changeView(Field.VERTICAL_SPEED);
            }
        });
        this._popup.add(jMenuItem3);
        boolean bl = true;
        FieldList fieldList = this._track.getFieldList();
        int n = 0;
        while (n < fieldList.getNumFields()) {
            Field field = fieldList.getField(n);
            if (!field.isBuiltIn()) {
                if (bl) {
                    this._popup.addSeparator();
                }
                bl = false;
                JMenuItem jMenuItem4 = new JMenuItem(field.getName());
                jMenuItem4.addActionListener(new MenuClicker(field));
                this._popup.add(jMenuItem4);
            }
            ++n;
        }
    }

    private int getLineScale(double d, double d2) {
        if (d2 - d < 2.0) {
            return -1;
        }
        int n = LINE_SCALES.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = LINE_SCALES[n2];
            int n4 = (int)(d2 / (double)n3) - (int)(d / (double)n3);
            if (n4 > 10) {
                return -1;
            }
            if (n4 > 1) {
                return n3;
            }
            ++n2;
        }
        return LINE_SCALES[n - 1];
    }

    public void dataUpdated(byte by) {
        if (by != 4) {
            this._data.init(Config.getUnitSet());
        }
        if ((by & 1) > 0) {
            this.makePopup();
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._track == null || this._track.getNumPoints() < 1) {
            return;
        }
        if (!mouseEvent.isMetaDown()) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n > 6 && n2 > 6 && n < this.getWidth() - 6 && n2 < this.getHeight() - 6) {
                int n3 = (int)((double)(mouseEvent.getX() - 6) / this._xScaleFactor);
                if (mouseEvent.isShiftDown()) {
                    this._trackInfo.extendSelection(n3);
                } else {
                    this._trackInfo.selectPoint(n3);
                }
            }
        } else {
            this._popup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void changeView(Field field) {
        if (field == Field.ALTITUDE) {
            if (!(this._data instanceof AltitudeData)) {
                this._data = new AltitudeData(this._track);
            }
        } else if (field == Field.SPEED) {
            if (!(this._data instanceof SpeedData)) {
                this._data = new SpeedData(this._track);
            }
        } else if (field == Field.VERTICAL_SPEED) {
            if (!(this._data instanceof VerticalSpeedData)) {
                this._data = new VerticalSpeedData(this._track);
            }
        } else if (!(this._data instanceof ArbitraryData) || ((ArbitraryData)this._data).getField() != field) {
            this._data = new ArbitraryData(this._track, field);
        }
        this._data.init(Config.getUnitSet());
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class MenuClicker
    implements ActionListener {
        private Field _field = null;

        MenuClicker(Field field) {
            this._field = field;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProfileChart.this.changeView(this._field);
        }
    }
}

