/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.core;

import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.core.CoreJavaFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaDirectoryService;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class CoreJavaDirectoryService
extends JavaDirectoryService {
    private static final Logger LOG = Logger.getInstance("#com.intellij.core.CoreJavaDirectoryService");

    @Override
    public PsiPackage getPackage(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "getPackage"));
        }
        return ServiceManager.getService(dir.getProject(), CoreJavaFileManager.class).getPackage(dir);
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "getClasses"));
        }
        LOG.assertTrue(dir.isValid());
        PsiClass[] psiClassArray = CoreJavaDirectoryService.getPsiClasses(dir, dir.getFiles());
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "getClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    public static PsiClass[] getPsiClasses(@NotNull PsiDirectory dir, PsiFile[] psiFiles) {
        VirtualFile virtualDir;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "getPsiClasses"));
        }
        FileIndexFacade index2 = FileIndexFacade.getInstance(dir.getProject());
        boolean onlyCompiled = index2.isInLibraryClasses(virtualDir = dir.getVirtualFile()) && !index2.isInSourceContent(virtualDir);
        ArrayList classes2 = null;
        for (PsiFile file : psiFiles) {
            PsiClass[] psiClasses;
            if (onlyCompiled && !(file instanceof ClsFileImpl) || !(file instanceof PsiClassOwner) || file.getViewProvider().getLanguages().size() != 1 || (psiClasses = ((PsiClassOwner)file).getClasses()).length == 0) continue;
            if (classes2 == null) {
                classes2 = new ArrayList();
            }
            ContainerUtil.addAll(classes2, psiClasses);
        }
        PsiClass[] psiClassArray = classes2 == null ? PsiClass.EMPTY_ARRAY : classes2.toArray(new PsiClass[classes2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "getPsiClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName, boolean askForUndefinedVariables) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName, boolean askForUndefinedVariables, @NotNull Map<String, String> additionalProperties) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (additionalProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalProperties", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkCreateClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "checkCreateClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "checkCreateClass"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiClass createInterface(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createInterface"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createInterface"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiClass createEnum(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createEnum"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createEnum"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiClass createAnnotationType(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createAnnotationType"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "createAnnotationType"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSourceRoot(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "isSourceRoot"));
        }
        return false;
    }

    @Override
    public LanguageLevel getLanguageLevel(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/kotlin/com/intellij/core/CoreJavaDirectoryService", "getLanguageLevel"));
        }
        return LanguageLevel.HIGHEST;
    }
}

