/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.extapi.psi.StubBasedPsiElementBase;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.Stub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;

public abstract class SubstrateRef {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.SubstrateRef");

    @NotNull
    public abstract ASTNode getNode();

    @Nullable
    public Stub getStub(int stubIndex) {
        return null;
    }

    @Nullable
    public Stub getGreenStub(int index2) {
        return this.getStub(index2);
    }

    public abstract boolean isValid();

    @NotNull
    public abstract PsiFile getContainingFile();

    @NotNull
    static SubstrateRef createInvalidRef(final @NotNull StubBasedPsiElementBase<?> psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/kotlin/com/intellij/psi/impl/source/SubstrateRef", "createInvalidRef"));
        }
        SubstrateRef substrateRef = new SubstrateRef(){

            @Override
            @NotNull
            public ASTNode getNode() {
                throw new PsiInvalidElementAccessException(psi);
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            @NotNull
            public PsiFile getContainingFile() {
                throw new PsiInvalidElementAccessException(psi);
            }
        };
        if (substrateRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/SubstrateRef", "createInvalidRef"));
        }
        return substrateRef;
    }

    public static SubstrateRef createAstStrongRef(final @NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/SubstrateRef", "createAstStrongRef"));
        }
        return new SubstrateRef(){

            @Override
            @NotNull
            public ASTNode getNode() {
                ASTNode aSTNode = node;
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/SubstrateRef$2", "getNode"));
                }
                return aSTNode;
            }

            @Override
            public boolean isValid() {
                FileASTNode fileElement = SharedImplUtil.findFileElement(node);
                PsiElement file = fileElement == null ? null : fileElement.getPsi();
                return file != null && file.isValid();
            }

            @Override
            @NotNull
            public PsiFile getContainingFile() {
                PsiFile file = SharedImplUtil.getContainingFile(node);
                if (file == null) {
                    throw PsiInvalidElementAccessException.createByNode(node, null);
                }
                PsiFile psiFile = file;
                if (psiFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/SubstrateRef$2", "getContainingFile"));
                }
                return psiFile;
            }
        };
    }

    public static class StubRef
    extends SubstrateRef {
        private final StubElement myStub;

        public StubRef(@NotNull StubElement stub) {
            if (stub == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/source/SubstrateRef$StubRef", "<init>"));
            }
            this.myStub = stub;
        }

        @Override
        @NotNull
        public ASTNode getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Stub getStub(int stubIndex) {
            StubElement stubElement = this.myStub;
            if (stubElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/SubstrateRef$StubRef", "getStub"));
            }
            return stubElement;
        }

        @Override
        public boolean isValid() {
            StubElement parent2 = this.myStub.getParentStub();
            if (parent2 == null) {
                LOG.error("No parent for stub " + this.myStub + " of class " + this.myStub.getClass());
                return false;
            }
            Object psi = parent2.getPsi();
            return psi != null && psi.isValid();
        }

        @Override
        @NotNull
        public PsiFile getContainingFile() {
            StubElement stub = this.myStub;
            while (!(stub instanceof PsiFileStub)) {
                stub = stub.getParentStub();
            }
            PsiFile psi = (PsiFile)stub.getPsi();
            if (psi != null) {
                PsiFile psiFile = psi;
                if (psiFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/SubstrateRef$StubRef", "getContainingFile"));
                }
                return psiFile;
            }
            PsiFile psiFile = this.reportError(stub);
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/SubstrateRef$StubRef", "getContainingFile"));
            }
            return psiFile;
        }

        private PsiFile reportError(StubElement stub) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            String reason = ((PsiFileStubImpl)stub).getInvalidationReason();
            PsiInvalidElementAccessException exception = new PsiInvalidElementAccessException((PsiElement)this.myStub.getPsi(), "no psi for file stub " + stub + ", invalidation reason=" + reason, null);
            if ("stub-psi mismatch".equals(reason)) {
                throw new ProcessCanceledException(exception);
            }
            throw exception;
        }
    }
}

