/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.KVariance;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.ScriptParameter;
import org.jetbrains.kotlin.script.ScriptTypeUtilKt$WhenMappings;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0015"}, d2={"getKotlinTypeByFqName", "Lorg/jetbrains/kotlin/types/KotlinType;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "fqName", "", "getKotlinTypeByKClass", "kClass", "Lkotlin/reflect/KClass;", "", "getKotlinTypeByKType", "kType", "Lkotlin/reflect/KType;", "getTypeProjection", "Lorg/jetbrains/kotlin/types/TypeProjection;", "kTypeProjection", "Lkotlin/reflect/KTypeProjection;", "getScriptParameters", "", "Lorg/jetbrains/kotlin/script/ScriptParameter;", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "kotlin-compiler"})
public final class ScriptTypeUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ScriptParameter> getScriptParameters(@NotNull KotlinScriptDefinition $receiver, @NotNull ScriptDescriptor scriptDescriptor) {
        List list2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
        KFunction<? extends Object> kFunction = KClasses.getPrimaryConstructor($receiver.getTemplate());
        if (kFunction != null && (kFunction = kFunction.getParameters()) != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)((Object)kFunction);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                KParameter kParameter = (KParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = it.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Name name = Name.identifier(string);
                Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(it.name!!)");
                ScriptParameter scriptParameter = new ScriptParameter(name, ScriptTypeUtilKt.getKotlinTypeByKType(scriptDescriptor, it.getType()));
                collection.add(scriptParameter);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public static final KotlinType getKotlinTypeByKClass(@NotNull ScriptDescriptor scriptDescriptor, @NotNull KClass<? extends Object> kClass2) {
        Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
        Intrinsics.checkParameterIsNotNull(kClass2, "kClass");
        String string = kClass2.getQualifiedName();
        if (string == null) {
            throw (Throwable)new RuntimeException("Cannot get FQN from " + kClass2);
        }
        return ScriptTypeUtilKt.getKotlinTypeByFqName(scriptDescriptor, string);
    }

    private static final KotlinType getKotlinTypeByFqName(ScriptDescriptor scriptDescriptor, String fqName2) {
        ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule(scriptDescriptor);
        ClassId classId = ClassId.topLevel(new FqName(fqName2));
        Intrinsics.checkExpressionValueIsNotNull(classId, "ClassId.topLevel(FqName(fqName))");
        StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
        Intrinsics.checkExpressionValueIsNotNull(storageManager, "LockBasedStorageManager.NO_LOCKS");
        SimpleType simpleType2 = FindClassInModuleKt.findNonGenericClassAcrossDependencies(moduleDescriptor, classId, new NotFoundClasses(storageManager, DescriptorUtilsKt.getModule(scriptDescriptor))).getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "scriptDescriptor.module.\u2026le)\n        ).defaultType");
        return simpleType2;
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinType getKotlinTypeByKType(ScriptDescriptor scriptDescriptor, KType kType) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        KClassifier classifier2 = kType.getClassifier();
        if (!(classifier2 instanceof KClass)) {
            throw (Throwable)new UnsupportedOperationException("Only classes are supported as parameters in script template: " + classifier2);
        }
        KotlinType type2 = ScriptTypeUtilKt.getKotlinTypeByKClass(scriptDescriptor, (KClass)classifier2);
        Iterable iterable = $receiver$iv = (Iterable)kType.getArguments();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KTypeProjection kTypeProjection = (KTypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            TypeProjection typeProjection = ScriptTypeUtilKt.getTypeProjection(scriptDescriptor, (KTypeProjection)it);
            collection.add(typeProjection);
        }
        List typeProjections = (List)destination$iv$iv;
        boolean isNullable = kType.isMarkedNullable();
        return KotlinTypeFactory.simpleType(Annotations.Companion.getEMPTY(), type2.getConstructor(), typeProjections, isNullable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final TypeProjection getTypeProjection(ScriptDescriptor scriptDescriptor, KTypeProjection kTypeProjection) {
        Variance variance;
        KType kType = kTypeProjection.getType();
        if (kType == null) {
            throw (Throwable)new UnsupportedOperationException("Star projections are not supported");
        }
        KType kType2 = kType;
        KotlinType type2 = ScriptTypeUtilKt.getKotlinTypeByKType(scriptDescriptor, kType2);
        KVariance kVariance = kTypeProjection.getVariance();
        if (kVariance == null) throw (Throwable)new UnsupportedOperationException("Star projections are not supported");
        switch (ScriptTypeUtilKt$WhenMappings.$EnumSwitchMapping$0[kVariance.ordinal()]) {
            case 1: {
                variance = Variance.IN_VARIANCE;
                break;
            }
            case 2: {
                variance = Variance.OUT_VARIANCE;
                break;
            }
            case 3: {
                variance = Variance.INVARIANT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Variance variance2 = variance;
        return new TypeProjectionImpl(variance2, type2);
    }
}

