/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.logging.events.EndOutputEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.UpdateNowEvent;
import org.gradle.internal.time.Clock;

public class ThrottlingOutputEventListener
implements OutputEventListener {
    private static final long UPDATE_NOW_FLUSH_INITIAL_DELAY_AND_PERIOD_MS = 100L;
    private final OutputEventListener listener;
    private final ScheduledExecutorService executor;
    private final Clock clock;
    private final int throttleMs;
    private final Object lock = new Object();
    private long lastUpdate;
    private final List<OutputEvent> queue = new ArrayList<OutputEvent>();

    public ThrottlingOutputEventListener(OutputEventListener listener, Clock clock) {
        this(listener, Integer.getInteger("org.gradle.console.throttle", 85), Executors.newSingleThreadScheduledExecutor(), clock);
    }

    ThrottlingOutputEventListener(OutputEventListener listener, int throttleMs, ScheduledExecutorService executor, Clock clock) {
        this.throttleMs = throttleMs;
        this.listener = listener;
        this.executor = executor;
        this.clock = clock;
        this.scheduleUpdateNow();
    }

    private void scheduleUpdateNow() {
        this.executor.scheduleAtFixedRate(new Runnable(){

            public void run() {
                ThrottlingOutputEventListener.this.onOutput(new UpdateNowEvent(ThrottlingOutputEventListener.this.clock.getCurrentTime()));
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutput(OutputEvent newEvent) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.add(newEvent);
            if (newEvent instanceof EndOutputEvent) {
                this.renderNow(this.clock.getCurrentTime());
                this.executor.shutdown();
                return;
            }
            if (this.queue.size() > 1) {
                return;
            }
            long now = this.clock.getCurrentTime();
            if (now - this.lastUpdate >= (long)this.throttleMs) {
                this.renderNow(now);
                return;
            }
            this.executor.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = ThrottlingOutputEventListener.this.lock;
                    synchronized (object) {
                        ThrottlingOutputEventListener.this.renderNow(ThrottlingOutputEventListener.this.clock.getCurrentTime());
                    }
                }
            }, (long)this.throttleMs, TimeUnit.MILLISECONDS);
        }
    }

    private void renderNow(long now) {
        if (this.queue.isEmpty()) {
            return;
        }
        for (OutputEvent event : this.queue) {
            this.listener.onOutput(event);
        }
        this.queue.clear();
        this.lastUpdate = now;
    }
}

