/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultSourceSetContainer;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.internal.Actions;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;

public class JavaPluginConvention {
    private ProjectInternal project;
    private String docsDirName;
    private String testResultsDirName;
    private String testReportDirName;
    private final SourceSetContainer sourceSets;
    private JavaVersion srcCompat;
    private JavaVersion targetCompat;

    public JavaPluginConvention(ProjectInternal project, Instantiator instantiator) {
        this.project = project;
        this.sourceSets = (SourceSetContainer)instantiator.newInstance(DefaultSourceSetContainer.class, new Object[]{project.getFileResolver(), project.getTasks(), instantiator, project.getServices().get(SourceDirectorySetFactory.class)});
        this.docsDirName = "docs";
        this.testResultsDirName = "test-results";
        this.testReportDirName = "tests";
    }

    public Object sourceSets(Closure closure) {
        return this.sourceSets.configure(closure);
    }

    public File getDocsDir() {
        return ((FileLookup)this.project.getServices().get(FileLookup.class)).getFileResolver(this.project.getBuildDir()).resolve((Object)this.docsDirName);
    }

    public File getTestResultsDir() {
        return ((FileLookup)this.project.getServices().get(FileLookup.class)).getFileResolver(this.project.getBuildDir()).resolve((Object)this.testResultsDirName);
    }

    public File getTestReportDir() {
        return ((FileLookup)this.project.getServices().get(FileLookup.class)).getFileResolver(this.getReportsDir()).resolve((Object)this.testReportDirName);
    }

    private File getReportsDir() {
        return ((ReportingExtension)this.project.getExtensions().getByType(ReportingExtension.class)).getBaseDir();
    }

    public JavaVersion getSourceCompatibility() {
        return this.srcCompat != null ? this.srcCompat : JavaVersion.current();
    }

    public void setSourceCompatibility(Object value) {
        this.setSourceCompatibility(JavaVersion.toVersion((Object)value));
    }

    public void setSourceCompatibility(JavaVersion value) {
        this.srcCompat = value;
    }

    public JavaVersion getTargetCompatibility() {
        return this.targetCompat != null ? this.targetCompat : this.getSourceCompatibility();
    }

    public void setTargetCompatibility(Object value) {
        this.setTargetCompatibility(JavaVersion.toVersion((Object)value));
    }

    public void setTargetCompatibility(JavaVersion value) {
        this.targetCompat = value;
    }

    public Manifest manifest() {
        return this.manifest((Action<? super Manifest>)Actions.doNothing());
    }

    public Manifest manifest(Closure closure) {
        return (Manifest)ConfigureUtil.configure((Closure)closure, (Object)this.createManifest());
    }

    public Manifest manifest(Action<? super Manifest> action) {
        Manifest manifest = this.createManifest();
        action.execute((Object)manifest);
        return manifest;
    }

    private Manifest createManifest() {
        return new DefaultManifest((PathToFileResolver)this.project.getFileResolver());
    }

    public String getDocsDirName() {
        return this.docsDirName;
    }

    public void setDocsDirName(String docsDirName) {
        this.docsDirName = docsDirName;
    }

    public String getTestResultsDirName() {
        return this.testResultsDirName;
    }

    public void setTestResultsDirName(String testResultsDirName) {
        this.testResultsDirName = testResultsDirName;
    }

    public String getTestReportDirName() {
        return this.testReportDirName;
    }

    public void setTestReportDirName(String testReportDirName) {
        this.testReportDirName = testReportDirName;
    }

    public SourceSetContainer getSourceSets() {
        return this.sourceSets;
    }

    public ProjectInternal getProject() {
        return this.project;
    }
}

