/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkipUpToDateTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipUpToDateTaskExecuter.class);
    private final TaskExecuter executer;

    public SkipUpToDateTaskExecuter(TaskExecuter executer) {
        this.executer = executer;
    }

    @Override
    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        LOGGER.debug("Determining if {} is up-to-date", (Object)task);
        Timer clock = Time.startTimer();
        TaskArtifactState taskArtifactState = context.getTaskArtifactState();
        ArrayList<String> messages = new ArrayList<String>(3);
        if (taskArtifactState.isUpToDate(messages)) {
            LOGGER.info("Skipping {} as it is up-to-date (took {}).", (Object)task, (Object)clock.getElapsed());
            state.setOutcome(TaskExecutionOutcome.UP_TO_DATE);
            context.setOriginBuildInvocationId(taskArtifactState.getOriginBuildInvocationId());
            return;
        }
        context.setUpToDateMessages((List<String>)ImmutableList.copyOf(messages));
        this.logOutOfDateMessages(messages, task, clock.getElapsed());
        this.executer.execute(task, state, context);
    }

    private void logOutOfDateMessages(List<String> messages, TaskInternal task, String took) {
        if (LOGGER.isInfoEnabled()) {
            Formatter formatter = new Formatter();
            formatter.format("Up-to-date check for %s took %s. It is not up-to-date because:", task, took);
            for (String message : messages) {
                formatter.format("%n  %s", message);
            }
            LOGGER.info(formatter.toString());
        }
    }
}

