/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.io.File;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.ScriptSourceHasher;
import org.gradle.internal.hash.ContentHasherFactory;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.resource.TextResource;

public class DefaultScriptSourceHasher
implements ScriptSourceHasher {
    private final FileHasher fileHasher;
    private final ContentHasherFactory contentHasherFactory;

    public DefaultScriptSourceHasher(FileHasher fileHasher, ContentHasherFactory contentHasherFactory) {
        this.fileHasher = fileHasher;
        this.contentHasherFactory = contentHasherFactory;
    }

    public HashCode hash(ScriptSource scriptSource) {
        TextResource resource = scriptSource.getResource();
        File file = resource.getFile();
        if (file != null) {
            return this.fileHasher.hash(file);
        }
        Hasher hasher = (Hasher)this.contentHasherFactory.create();
        hasher.putString((CharSequence)resource.getText());
        return hasher.hash();
    }
}

