/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.util.FS;

class CachedObjectDirectory
extends FileObjectDatabase {
    private ObjectIdOwnerMap<UnpackedObjectId> unpackedObjects;
    private final ObjectDirectory wrapped;
    private CachedObjectDirectory[] alts;

    CachedObjectDirectory(ObjectDirectory wrapped) {
        this.wrapped = wrapped;
        this.unpackedObjects = this.scanLoose();
    }

    private ObjectIdOwnerMap<UnpackedObjectId> scanLoose() {
        ObjectIdOwnerMap<UnpackedObjectId> m = new ObjectIdOwnerMap<UnpackedObjectId>();
        File objects = this.wrapped.getDirectory();
        String[] fanout = objects.list();
        if (fanout == null) {
            return m;
        }
        for (String d : fanout) {
            String[] entries;
            if (d.length() != 2 || (entries = new File(objects, d).list()) == null) continue;
            for (String e : entries) {
                if (e.length() != 38) continue;
                try {
                    ObjectId id = ObjectId.fromString(d + e);
                    m.add(new UnpackedObjectId(id));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return m;
    }

    @Override
    public void close() {
    }

    @Override
    public ObjectDatabase newCachedDatabase() {
        return this;
    }

    @Override
    File getDirectory() {
        return this.wrapped.getDirectory();
    }

    @Override
    File fileFor(AnyObjectId id) {
        return this.wrapped.fileFor(id);
    }

    @Override
    Config getConfig() {
        return this.wrapped.getConfig();
    }

    @Override
    FS getFS() {
        return this.wrapped.getFS();
    }

    @Override
    Set<ObjectId> getShallowCommits() throws IOException {
        return this.wrapped.getShallowCommits();
    }

    private CachedObjectDirectory[] myAlternates() {
        if (this.alts == null) {
            ObjectDirectory.AlternateHandle[] src = this.wrapped.myAlternates();
            this.alts = new CachedObjectDirectory[src.length];
            for (int i = 0; i < this.alts.length; ++i) {
                this.alts[i] = src[i].db.newCachedFileObjectDatabase();
            }
        }
        return this.alts;
    }

    @Override
    void resolve(Set<ObjectId> matches, AbbreviatedObjectId id) throws IOException {
        this.wrapped.resolve(matches, id);
    }

    @Override
    public boolean has(AnyObjectId objectId) throws IOException {
        if (this.unpackedObjects.contains(objectId)) {
            return true;
        }
        if (this.wrapped.hasPackedObject(objectId)) {
            return true;
        }
        for (CachedObjectDirectory alt : this.myAlternates()) {
            if (!alt.has(objectId)) continue;
            return true;
        }
        return false;
    }

    @Override
    ObjectLoader openObject(WindowCursor curs, AnyObjectId objectId) throws IOException {
        ObjectLoader ldr = this.openLooseObject(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        ldr = this.wrapped.openPackedObject(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        for (CachedObjectDirectory alt : this.myAlternates()) {
            ldr = alt.openObject(curs, objectId);
            if (ldr == null) continue;
            return ldr;
        }
        return null;
    }

    @Override
    long getObjectSize(WindowCursor curs, AnyObjectId objectId) throws IOException {
        return this.wrapped.getObjectSize(curs, objectId);
    }

    @Override
    ObjectLoader openLooseObject(WindowCursor curs, AnyObjectId id) throws IOException {
        if (this.unpackedObjects.contains(id)) {
            ObjectLoader ldr = this.wrapped.openLooseObject(curs, id);
            if (ldr != null) {
                return ldr;
            }
            this.unpackedObjects = this.scanLoose();
        }
        return null;
    }

    @Override
    FileObjectDatabase.InsertLooseObjectResult insertUnpackedObject(File tmp, ObjectId objectId, boolean createDuplicate) throws IOException {
        FileObjectDatabase.InsertLooseObjectResult result = this.wrapped.insertUnpackedObject(tmp, objectId, createDuplicate);
        switch (result) {
            case INSERTED: 
            case EXISTS_LOOSE: {
                this.unpackedObjects.addIfAbsent(new UnpackedObjectId(objectId));
                break;
            }
        }
        return result;
    }

    @Override
    PackFile openPack(File pack) throws IOException {
        return this.wrapped.openPack(pack);
    }

    @Override
    void selectObjectRepresentation(PackWriter packer, ObjectToPack otp, WindowCursor curs) throws IOException {
        this.wrapped.selectObjectRepresentation(packer, otp, curs);
    }

    @Override
    Collection<PackFile> getPacks() {
        return this.wrapped.getPacks();
    }

    private static class UnpackedObjectId
    extends ObjectIdOwnerMap.Entry {
        UnpackedObjectId(AnyObjectId id) {
            super(id);
        }
    }
}

