/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.DependencyMetadataRules;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantMetadata;

abstract class DefaultConfigurationMetadata
implements ConfigurationMetadata {
    private final ModuleComponentIdentifier componentId;
    private final String name;
    private final ImmutableList<? extends DefaultConfigurationMetadata> parents;
    private final List<ModuleDependencyMetadata> configDependencies = Lists.newArrayList();
    private final ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts;
    private final boolean transitive;
    private final boolean visible;
    private final List<String> hierarchy;
    private DependencyMetadataRules dependencyMetadataRules;
    private List<ModuleDependencyMetadata> calculatedDependencies;

    DefaultConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableList<? extends DefaultConfigurationMetadata> parents, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts) {
        this.componentId = componentId;
        this.name = name;
        this.parents = parents;
        this.transitive = transitive;
        this.visible = visible;
        this.artifacts = artifacts;
        this.hierarchy = this.calculateHierarchy();
    }

    @Override
    public DisplayName asDescribable() {
        return Describables.of((Object)this.componentId, (Object)"configuration", (Object)this.name);
    }

    public String toString() {
        return this.asDescribable().getDisplayName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableList<? extends DefaultConfigurationMetadata> getParents() {
        return this.parents;
    }

    @Override
    public Collection<String> getHierarchy() {
        return this.hierarchy;
    }

    private List<String> calculateHierarchy() {
        ImmutableList<? extends DefaultConfigurationMetadata> parents = this.getParents();
        if (parents.isEmpty()) {
            return Collections.singletonList(this.name);
        }
        LinkedHashSet<String> hierarchy = new LinkedHashSet<String>(1 + parents.size());
        this.populateHierarchy(hierarchy);
        return ImmutableList.copyOf(hierarchy);
    }

    private void populateHierarchy(Set<String> accumulator) {
        accumulator.add(this.name);
        for (DefaultConfigurationMetadata parent : this.getParents()) {
            parent.populateHierarchy(accumulator);
        }
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return ImmutableAttributes.EMPTY;
    }

    @Override
    public boolean isCanBeConsumed() {
        return true;
    }

    @Override
    public boolean isCanBeResolved() {
        return false;
    }

    @Override
    public List<? extends DependencyMetadata> getDependencies() {
        if (this.calculatedDependencies == null) {
            this.calculatedDependencies = this.dependencyMetadataRules == null ? this.configDependencies : this.dependencyMetadataRules.execute(this.configDependencies);
        }
        return this.calculatedDependencies;
    }

    void populateDependencies(Iterable<? extends ModuleDependencyMetadata> dependencies, DependencyMetadataRules dependencyMetadataRules) {
        for (ModuleDependencyMetadata moduleDependencyMetadata : dependencies) {
            if (!this.include(moduleDependencyMetadata)) continue;
            this.configDependencies.add(moduleDependencyMetadata);
        }
        this.calculatedDependencies = null;
        this.dependencyMetadataRules = dependencyMetadataRules;
    }

    private boolean include(DependencyMetadata dependency) {
        Collection<String> hierarchy = this.getHierarchy();
        for (String moduleConfiguration : dependency.getModuleConfigurations()) {
            if (moduleConfiguration.equals("%") || hierarchy.contains(moduleConfiguration)) {
                return true;
            }
            if (!moduleConfiguration.equals("*")) continue;
            boolean include = true;
            for (String conf2 : dependency.getModuleConfigurations()) {
                if (!conf2.startsWith("!") || !conf2.substring(1).equals(this.getName())) continue;
                include = false;
                break;
            }
            if (!include) continue;
            return true;
        }
        return false;
    }

    public List<? extends ModuleComponentArtifactMetadata> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public Set<? extends VariantMetadata> getVariants() {
        return ImmutableSet.of((Object)new DefaultVariantMetadata(this.asDescribable(), (AttributeContainerInternal)this.getAttributes(), this.getArtifacts()));
    }

    @Override
    public ModuleComponentArtifactMetadata artifact(IvyArtifactName artifact) {
        return new DefaultModuleComponentArtifactMetadata(this.componentId, artifact);
    }
}

