/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;

public class ModuleDependencyMetadataWrapper
implements ModuleDependencyMetadata {
    private final DependencyMetadata delegate;

    public ModuleDependencyMetadataWrapper(DependencyMetadata delegate) {
        this.delegate = delegate;
    }

    @Override
    public Set<ComponentArtifactMetadata> getArtifacts(ConfigurationMetadata fromConfiguration, ConfigurationMetadata toConfiguration) {
        return this.delegate.getArtifacts(fromConfiguration, toConfiguration);
    }

    @Override
    public Set<IvyArtifactName> getArtifacts() {
        return this.delegate.getArtifacts();
    }

    @Override
    public ModuleDependencyMetadata withRequestedVersion(VersionConstraint requestedVersion) {
        ModuleComponentSelector selector = this.getSelector();
        ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(selector.getGroup(), selector.getModule(), requestedVersion);
        return new ModuleDependencyMetadataWrapper(this.delegate.withTarget((ComponentSelector)newSelector));
    }

    @Override
    public DependencyMetadata withTarget(ComponentSelector target) {
        return this.delegate.withTarget(target);
    }

    @Override
    public ModuleComponentSelector getSelector() {
        return (ModuleComponentSelector)this.delegate.getSelector();
    }

    @Override
    public List<Exclude> getExcludes() {
        return this.delegate.getExcludes();
    }

    @Override
    public List<Exclude> getExcludes(Collection<String> configurations) {
        return this.delegate.getExcludes(configurations);
    }

    @Override
    public Set<ConfigurationMetadata> selectConfigurations(ImmutableAttributes consumerAttributes, ComponentResolveMetadata fromComponent, ConfigurationMetadata fromConfiguration, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema) {
        return this.delegate.selectConfigurations(consumerAttributes, fromComponent, fromConfiguration, targetComponent, consumerSchema);
    }

    @Override
    public Set<String> getModuleConfigurations() {
        return this.delegate.getModuleConfigurations();
    }

    @Override
    public boolean isChanging() {
        return this.delegate.isChanging();
    }

    @Override
    public boolean isTransitive() {
        return this.delegate.isTransitive();
    }

    @Override
    public boolean isForce() {
        return this.delegate.isForce();
    }

    @Override
    public boolean isOptional() {
        return this.delegate.isOptional();
    }

    @Override
    public String getDynamicConstraintVersion() {
        return this.getSelector().getVersionConstraint().getPreferredVersion();
    }
}

