/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api;

import java.util.concurrent.Callable;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.OrElseBlock;
import org.multiverse.api.Txn;
import org.multiverse.api.TxnExecutor;
import org.multiverse.api.TxnThreadLocal;
import org.multiverse.api.callables.TxnBooleanCallable;
import org.multiverse.api.callables.TxnCallable;
import org.multiverse.api.callables.TxnDoubleCallable;
import org.multiverse.api.callables.TxnIntCallable;
import org.multiverse.api.callables.TxnLongCallable;
import org.multiverse.api.callables.TxnVoidCallable;
import org.multiverse.api.collections.TxnCollectionsFactory;
import org.multiverse.api.collections.TxnDeque;
import org.multiverse.api.collections.TxnList;
import org.multiverse.api.collections.TxnMap;
import org.multiverse.api.collections.TxnQueue;
import org.multiverse.api.collections.TxnSet;
import org.multiverse.api.collections.TxnStack;
import org.multiverse.api.lifecycle.TxnEvent;
import org.multiverse.api.lifecycle.TxnListener;
import org.multiverse.api.references.TxnBoolean;
import org.multiverse.api.references.TxnDouble;
import org.multiverse.api.references.TxnInteger;
import org.multiverse.api.references.TxnLong;
import org.multiverse.api.references.TxnRef;
import org.multiverse.api.references.TxnRefFactory;

public final class StmUtils {
    private static final TxnRefFactory refFactory = GlobalStmInstance.getGlobalStmInstance().getDefaultRefFactory();
    private static final TxnExecutor defaultTxnExecutor = GlobalStmInstance.getGlobalStmInstance().getDefaultTxnExecutor();
    private static final OrElseBlock orelseBlock = GlobalStmInstance.getGlobalStmInstance().newOrElseBlock();
    private static final TxnCollectionsFactory txnCollectionsFactory = GlobalStmInstance.getGlobalStmInstance().getDefaultTxnCollectionFactory();

    public static <E> TxnList<E> newTxnLinkedList() {
        return txnCollectionsFactory.newLinkedList();
    }

    public static <E> TxnStack<E> newTxnStack() {
        return txnCollectionsFactory.newStack();
    }

    public static <E> TxnStack<E> newTxnStack(int capacity) {
        return txnCollectionsFactory.newStack(capacity);
    }

    public static <E> TxnQueue<E> newTxnQueue() {
        return txnCollectionsFactory.newQueue();
    }

    public static <E> TxnQueue<E> newTxnQueue(int capacity) {
        return txnCollectionsFactory.newQueue(capacity);
    }

    public static <E> TxnDeque<E> newTxnDeque() {
        return txnCollectionsFactory.newDeque();
    }

    public static <E> TxnDeque<E> newTxnDeque(int capacity) {
        return txnCollectionsFactory.newDeque(capacity);
    }

    public static <E> TxnSet<E> newTxnHashSet() {
        return txnCollectionsFactory.newHashSet();
    }

    public static <K, V> TxnMap<K, V> newTxnHashMap() {
        return txnCollectionsFactory.newHashMap();
    }

    public static void atomic(final Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable can't be null");
        }
        StmUtils.atomic(new TxnVoidCallable(){

            @Override
            public void call(Txn txn) throws Exception {
                runnable.run();
            }
        });
    }

    public static <E> E atomic(final Callable<E> callable) {
        if (callable == null) {
            throw new NullPointerException("callable can't be null");
        }
        return StmUtils.atomic(new TxnCallable<E>(){

            @Override
            public E call(Txn txn) throws Exception {
                return callable.call();
            }
        });
    }

    public static <E> E atomic(TxnCallable<E> callable) {
        return defaultTxnExecutor.execute(callable);
    }

    public static <E> E atomicChecked(TxnCallable<E> callable) throws Exception {
        return defaultTxnExecutor.executeChecked(callable);
    }

    public static <E> E atomic(TxnCallable<E> either, TxnCallable<E> orelse) {
        return orelseBlock.execute(either, orelse);
    }

    public static <E> E atomicChecked(TxnCallable<E> either, TxnCallable<E> orelse) throws Exception {
        return orelseBlock.executeChecked(either, orelse);
    }

    public static int atomic(TxnIntCallable callable) {
        return defaultTxnExecutor.execute(callable);
    }

    public static int atomicChecked(TxnIntCallable callable) throws Exception {
        return defaultTxnExecutor.executeChecked(callable);
    }

    public static int atomic(TxnIntCallable either, TxnIntCallable orelse) {
        return orelseBlock.execute(either, orelse);
    }

    public static int atomicChecked(TxnIntCallable either, TxnIntCallable orelse) throws Exception {
        return orelseBlock.executeChecked(either, orelse);
    }

    public static long atomic(TxnLongCallable callable) {
        return defaultTxnExecutor.execute(callable);
    }

    public static long atomicChecked(TxnLongCallable callable) throws Exception {
        return defaultTxnExecutor.executeChecked(callable);
    }

    public static long atomic(TxnLongCallable either, TxnLongCallable orelse) {
        return orelseBlock.execute(either, orelse);
    }

    public static long atomicChecked(TxnLongCallable either, TxnLongCallable orelse) throws Exception {
        return orelseBlock.executeChecked(either, orelse);
    }

    public static double atomic(TxnDoubleCallable callable) {
        return defaultTxnExecutor.execute(callable);
    }

    public static double atomicChecked(TxnDoubleCallable callable) throws Exception {
        return defaultTxnExecutor.executeChecked(callable);
    }

    public static double atomic(TxnDoubleCallable either, TxnDoubleCallable orelse) {
        return orelseBlock.execute(either, orelse);
    }

    public static double atomicChecked(TxnDoubleCallable either, TxnDoubleCallable orelse) throws Exception {
        return orelseBlock.executeChecked(either, orelse);
    }

    public static boolean atomic(TxnBooleanCallable callable) {
        return defaultTxnExecutor.execute(callable);
    }

    public static boolean atomicChecked(TxnBooleanCallable callable) throws Exception {
        return defaultTxnExecutor.executeChecked(callable);
    }

    public static boolean atomic(TxnBooleanCallable either, TxnBooleanCallable orelse) {
        return orelseBlock.execute(either, orelse);
    }

    public static boolean atomicChecked(TxnBooleanCallable either, TxnBooleanCallable orelse) throws Exception {
        return orelseBlock.executeChecked(either, orelse);
    }

    public static void atomic(TxnVoidCallable callable) {
        defaultTxnExecutor.execute(callable);
    }

    public static void atomicChecked(TxnVoidCallable callable) throws Exception {
        defaultTxnExecutor.executeChecked(callable);
    }

    public static void atomic(TxnVoidCallable either, TxnVoidCallable orelse) {
        orelseBlock.execute(either, orelse);
    }

    public static void atomicChecked(TxnVoidCallable either, TxnVoidCallable orelse) throws Exception {
        orelseBlock.executeChecked(either, orelse);
    }

    public static TxnInteger newTxnInteger(int value) {
        return refFactory.newTxnInteger(value);
    }

    public static TxnInteger newTxnInteger() {
        return refFactory.newTxnInteger(0);
    }

    public static TxnLong newTxnLong() {
        return refFactory.newTxnLong(0L);
    }

    public static TxnLong newTxnLong(long value) {
        return refFactory.newTxnLong(value);
    }

    public static TxnDouble newTxnDouble() {
        return refFactory.newTxnDouble(0.0);
    }

    public static TxnDouble newTxnDouble(double value) {
        return refFactory.newTxnDouble(value);
    }

    public static TxnBoolean newTxnBoolean() {
        return refFactory.newTxnBoolean(false);
    }

    public static TxnBoolean newTxnBoolean(boolean value) {
        return refFactory.newTxnBoolean(value);
    }

    public static <E> TxnRef<E> newTxnRef() {
        return refFactory.newTxnRef(null);
    }

    public static <E> TxnRef<E> newTxnRef(E value) {
        return refFactory.newTxnRef(value);
    }

    public static void retry() {
        Txn txn = TxnThreadLocal.getRequiredThreadLocalTxn();
        txn.retry();
    }

    public static void prepare() {
        Txn txn = TxnThreadLocal.getRequiredThreadLocalTxn();
        txn.prepare();
    }

    public static void abort() {
        Txn txn = TxnThreadLocal.getRequiredThreadLocalTxn();
        txn.abort();
    }

    public static void commit() {
        Txn txn = TxnThreadLocal.getRequiredThreadLocalTxn();
        txn.commit();
    }

    public static void scheduleCompensatingOrDeferredTask(final Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        Txn txn = TxnThreadLocal.getRequiredThreadLocalTxn();
        txn.register(new TxnListener(){

            @Override
            public void notify(Txn txn, TxnEvent event) {
                if (event == TxnEvent.PostCommit || event == TxnEvent.PostAbort) {
                    task.run();
                }
            }
        });
    }

    public static void scheduleDeferredTask(final Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        Txn txn = TxnThreadLocal.getRequiredThreadLocalTxn();
        txn.register(new TxnListener(){

            @Override
            public void notify(Txn txn, TxnEvent event) {
                if (event == TxnEvent.PostCommit) {
                    task.run();
                }
            }
        });
    }

    public static void scheduleCompensatingTask(final Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        Txn txn = TxnThreadLocal.getRequiredThreadLocalTxn();
        txn.register(new TxnListener(){

            @Override
            public void notify(Txn txn, TxnEvent event) {
                if (event == TxnEvent.PostAbort) {
                    task.run();
                }
            }
        });
    }

    private StmUtils() {
    }
}

