/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars;

import groovy.lang.Closure;
import groovyx.gpars.dataflow.operator.DataflowProcessor;
import java.util.Arrays;

public abstract class DataflowMessagingRunnable
extends Closure {
    private static final long serialVersionUID = 4796783310470426395L;
    private final Class[] defaultParamTypes;
    private final int numberOfParameters;

    protected DataflowMessagingRunnable(int numberOfParameters) {
        this(null, numberOfParameters);
    }

    protected DataflowMessagingRunnable(Object owner, int numberOfParameters) {
        super(owner);
        this.numberOfParameters = numberOfParameters;
        this.defaultParamTypes = new Class[numberOfParameters];
        Arrays.fill(this.defaultParamTypes, Object.class);
    }

    public DataflowProcessor getOwningProcessor() {
        return (DataflowProcessor)this.getDelegate();
    }

    public int getMaximumNumberOfParameters() {
        return this.numberOfParameters;
    }

    public Class[] getParameterTypes() {
        return (Class[])this.defaultParamTypes.clone();
    }

    public final Object call() {
        throw new UnsupportedOperationException("DFMessageRunnable needs arguments to run.");
    }

    public final Object call(Object ... args) {
        this.doRun(args);
        return null;
    }

    protected abstract void doRun(Object ... var1);
}

