# time-stamp [![NPM version](https://badge.fury.io/js/time-stamp.svg)](http://badge.fury.io/js/time-stamp)  [![Build Status](https://travis-ci.org/jonschlinkert/time-stamp.svg)](https://travis-ci.org/jonschlinkert/time-stamp)

> Get a formatted timestamp.

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i time-stamp --save
```

## Usage

```js
var timestamp = require('time-stamp');

timestamp();
//=> '2015:04:01'

timestamp('YYYY:MM:DD');
//=> '2015:04:01'

timestamp('[YYYY:MM:DD]');
//=> '[2015:04:01]'

timestamp('YYYY/MM/DD');
//=> '2015/04/01'

timestamp('YYYY:MM');
//=> '2015:04'

timestamp('YYYY');
//=> '2015'

timestamp('MM');
//=> '04'

timestamp('DD');
//=> '01'

timestamp('hh');
//=> '01'

timestamp('mm');
//=> '59'

timestamp('ss');
//=> '09'

timestamp('ms');
//=> '783'
```

**Valid patterns**

* `YYYY`: full year (ex: **2015**)
* `MM`: month (ex: **04**)
* `DD`: day (ex: **01**)
* `HH`: hours (ex: **12**)
* `mm`: minutes (ex: **59**)
* `ss`: seconds (ex: **09**)
* `ms`: milliseconds (ex: **532**)

## Related projects

* [days](https://www.npmjs.com/package/days): Days of the week. | [homepage](https://github.com/jonschlinkert/days)
* [iso-week](https://www.npmjs.com/package/iso-week): Get the ISO week of the year. | [homepage](https://github.com/jonschlinkert/iso-week)
* [month](https://www.npmjs.com/package/month): Get the name or number of the current month or any month of the year. | [homepage](https://github.com/datetime/month)
* [months](https://www.npmjs.com/package/months): Months of the year. | [homepage](https://github.com/jonschlinkert/months)
* [o-clock](https://www.npmjs.com/package/o-clock): Simple utility for displaying the time in 12-hour clock format. | [homepage](https://github.com/jonschlinkert/o-clock)
* [seconds](https://www.npmjs.com/package/seconds): Get the number of seconds for a minute, hour, day and week. | [homepage](https://github.com/jonschlinkert/seconds)
* [week](https://www.npmjs.com/package/week): Get the current week number. | [homepage](https://github.com/jonschlinkert/week)
* [weekday](https://www.npmjs.com/package/weekday): Get the name and number of the current weekday. Or get the name of the… [more](https://www.npmjs.com/package/weekday) | [homepage](https://github.com/jonschlinkert/weekday)
* [year](https://www.npmjs.com/package/year): Simple utility to get the current year with 2 or 4 digits. | [homepage](https://github.com/jonschlinkert/year)

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/time-stamp/issues/new).

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on December 04, 2015._