/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.TaskManager;

public class CloseDialog
extends EnhancedDialog {
    private final View view;
    private final JList<String> bufferList;
    private final DefaultListModel<String> bufferModel;
    private final JButton selectAll;
    private final JButton save;
    private final JButton discard;
    private final JButton cancel;
    private boolean ok;
    boolean selectAllFlag;

    public CloseDialog(View view) {
        this(view, Arrays.asList(jEdit.getBuffers()));
    }

    public CloseDialog(View view, Collection<Buffer> collection) {
        super(view, jEdit.getProperty("close.title"), true);
        this.view = view;
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        Box box = new Box(1);
        box.add(new JLabel(UIManager.getIcon("OptionPane.warningIcon")));
        box.add(Box.createGlue());
        jPanel.add("West", box);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(jEdit.getProperty("close.caption"));
        jLabel.setBorder(new EmptyBorder(0, 0, 6, 0));
        jPanel2.add("North", jLabel);
        this.bufferModel = new DefaultListModel();
        this.bufferList = new JList(this.bufferModel);
        this.bufferList.setVisibleRowCount(10);
        this.bufferList.addListSelectionListener(new ListHandler());
        for (Buffer object2 : collection) {
            if (!object2.isDirty()) continue;
            this.bufferModel.addElement(object2.getPath());
        }
        jPanel2.add("Center", new JScrollPane(this.bufferList));
        jPanel.add("Center", jPanel2);
        ActionHandler actionHandler = new ActionHandler();
        Box box2 = new Box(0);
        box2.add(Box.createGlue());
        this.selectAll = new JButton(jEdit.getProperty("close.selectAll"));
        box2.add(this.selectAll);
        this.selectAll.setMnemonic(jEdit.getProperty("close.selectAll.mnemonic").charAt(0));
        this.selectAll.addActionListener(actionHandler);
        box2.add(Box.createHorizontalStrut(6));
        this.save = new JButton(jEdit.getProperty("close.save"));
        box2.add(this.save);
        this.save.setMnemonic(jEdit.getProperty("close.save.mnemonic").charAt(0));
        this.save.addActionListener(actionHandler);
        box2.add(Box.createHorizontalStrut(6));
        this.discard = new JButton(jEdit.getProperty("close.discard"));
        box2.add(this.discard);
        this.discard.setMnemonic(jEdit.getProperty("close.discard.mnemonic").charAt(0));
        this.discard.addActionListener(actionHandler);
        box2.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        box2.add(this.cancel);
        this.cancel.addActionListener(actionHandler);
        box2.add(Box.createGlue());
        this.bufferList.setSelectedIndex(0);
        jPanel.add("South", box2);
        jPanel.getRootPane().setDefaultButton(this.cancel);
        GenericGUIUtilities.requestFocus(this, this.bufferList);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    public boolean isOK() {
        return this.ok;
    }

    @Override
    public void ok() {
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    private void updateButtons() {
        int n = this.bufferList.getSelectedIndex();
        this.save.getModel().setEnabled(n != -1);
        this.discard.getModel().setEnabled(n != -1);
    }

    private class ListHandler
    implements ListSelectionListener {
        private ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (CloseDialog.this.selectAllFlag) {
                return;
            }
            int n = CloseDialog.this.bufferList.getSelectedIndex();
            if (n != -1) {
                String string = (String)CloseDialog.this.bufferModel.getElementAt(n);
                Buffer buffer = jEdit.getBuffer(string);
                if (buffer == null) {
                    Log.log(1, this, "Buffer " + string + " is already closed");
                    CloseDialog.this.bufferModel.removeElementAt(n);
                } else {
                    CloseDialog.this.view.showBuffer(buffer);
                }
            }
            CloseDialog.this.updateButtons();
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == CloseDialog.this.selectAll) {
                try {
                    CloseDialog.this.selectAllFlag = true;
                    CloseDialog.this.bufferList.setSelectionInterval(0, CloseDialog.this.bufferModel.getSize() - 1);
                }
                finally {
                    CloseDialog.this.selectAllFlag = false;
                }
                CloseDialog.this.bufferList.requestFocus();
            } else if (object == CloseDialog.this.save) {
                List list = CloseDialog.this.bufferList.getSelectedValuesList();
                for (String string : list) {
                    Buffer buffer = jEdit.getBuffer(string);
                    if (!buffer.save(CloseDialog.this.view, null, true, true)) {
                        return;
                    }
                    TaskManager.instance.waitForIoTasks();
                    if (buffer.getBooleanProperty("BufferIORequest__error")) {
                        return;
                    }
                    jEdit._closeBuffer(CloseDialog.this.view, buffer);
                    CloseDialog.this.bufferModel.removeElement(string);
                }
                if (CloseDialog.this.bufferModel.getSize() == 0) {
                    CloseDialog.this.ok = true;
                    CloseDialog.this.dispose();
                } else {
                    CloseDialog.this.bufferList.setSelectedIndex(0);
                    CloseDialog.this.bufferList.requestFocus();
                }
            } else if (object == CloseDialog.this.discard) {
                List list = CloseDialog.this.bufferList.getSelectedValuesList();
                for (String string : list) {
                    Buffer buffer = jEdit.getBuffer(string);
                    jEdit._closeBuffer(CloseDialog.this.view, buffer);
                    CloseDialog.this.bufferModel.removeElement(string);
                }
                if (CloseDialog.this.bufferModel.getSize() == 0) {
                    CloseDialog.this.ok = true;
                    CloseDialog.this.dispose();
                } else {
                    CloseDialog.this.bufferList.setSelectedIndex(0);
                    CloseDialog.this.bufferList.requestFocus();
                }
            } else if (object == CloseDialog.this.cancel) {
                CloseDialog.this.cancel();
            }
        }
    }
}

