/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.SB;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;

public class StateScript {
    private int modelIndex;
    private BS bsBonds;
    private BS bsAtoms1;
    private BS bsAtoms2;
    private String script1;
    private String script2;
    public boolean inDefinedStateBlock;

    StateScript(int modelIndex, String script1, BS bsBonds, BS bsAtoms1, BS bsAtoms2, String script2, boolean inDefinedStateBlock) {
        this.modelIndex = modelIndex;
        this.script1 = script1;
        this.bsBonds = BSUtil.copy(bsBonds);
        this.bsAtoms1 = BSUtil.copy(bsAtoms1);
        this.bsAtoms2 = BSUtil.copy(bsAtoms2);
        this.script2 = script2;
        this.inDefinedStateBlock = inDefinedStateBlock;
    }

    public boolean isValid() {
        return !(this.script1 == null || this.script1.length() <= 0 || this.bsBonds != null && this.bsBonds.nextSetBit(0) < 0 || this.bsAtoms1 != null && this.bsAtoms1.nextSetBit(0) < 0 || this.bsAtoms2 != null && this.bsAtoms2.nextSetBit(0) < 0);
    }

    public String toString() {
        String s;
        if (!this.isValid()) {
            return "";
        }
        SB sb = SB.newS(this.script1);
        if (this.bsBonds != null) {
            sb.append(" ").append(Escape.eBond(this.bsBonds));
        }
        if (this.bsAtoms1 != null) {
            sb.append(" ").append(Escape.eBS(this.bsAtoms1));
        }
        if (this.bsAtoms2 != null) {
            sb.append(" ").append(Escape.eBS(this.bsAtoms2));
        }
        if (this.script2 != null) {
            sb.append(" ").append(this.script2);
        }
        if (!(s = sb.toString()).endsWith(";")) {
            s = s + ";";
        }
        return s;
    }

    public boolean isConnect() {
        return this.script1.indexOf("connect") >= 0;
    }

    public boolean deleteAtoms(int modelIndex, BS bsBonds, BS bsAtoms) {
        if (modelIndex == this.modelIndex) {
            return false;
        }
        if (modelIndex > this.modelIndex) {
            return true;
        }
        BSUtil.deleteBits(this.bsBonds, bsBonds);
        BSUtil.deleteBits(this.bsAtoms1, bsAtoms);
        BSUtil.deleteBits(this.bsAtoms2, bsAtoms);
        return this.isValid();
    }

    public void setModelIndex(int index) {
        this.modelIndex = index;
    }
}

