/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import javajs.util.CU;
import jspecview.api.VisibleInterface;
import jspecview.common.Coordinate;
import jspecview.common.Spectrum;

public class Visible
implements VisibleInterface {
    @Override
    public int getColour(Spectrum spectrum, boolean bl) {
        int n;
        Coordinate[] coordinateArray = spectrum.getXYCoords();
        boolean bl2 = spectrum.isAbsorbance();
        double[] dArray = new double[4];
        Visible.getXYZfitted(coordinateArray, bl2, dArray);
        dArray[0] = dArray[0] / dArray[3];
        dArray[1] = dArray[1] / dArray[3];
        dArray[2] = dArray[2] / dArray[3];
        double[] dArray2 = new double[]{dArray[0] * 3.241 + dArray[1] * -1.5374 + dArray[2] * -0.4986, dArray[0] * -0.9692 + dArray[1] * 1.876 + dArray[2] * 0.0416, dArray[0] * 0.0556 + dArray[1] * -0.204 + dArray[2] * 1.057};
        double d = 2.4;
        for (n = 0; n < 3; ++n) {
            dArray2[n] = dArray2[n] > 0.00304 ? 1.055 * Math.pow(dArray2[n], 1.0 / d) - 0.055 : 12.92 * dArray2[n];
        }
        n = CU.rgb(Visible.fix(dArray2[0]), Visible.fix(dArray2[1]), Visible.fix(dArray2[2]));
        return n;
    }

    private static int fix(double d) {
        return d <= 0.0 ? 0 : (d >= 1.0 ? 255 : (int)Math.round(255.0 * d));
    }

    private static void getXYZfitted(Coordinate[] coordinateArray, boolean bl, double[] dArray) {
        int n = coordinateArray.length;
        while (--n >= 0) {
            double d = coordinateArray[n].getXVal();
            if (d < 400.0 || d > 700.0) continue;
            double d2 = Visible.gauss(85.7145, 2.05719E-5, d - 607.263) + Visible.gauss(57.7256, 1.26451E-4, d - 457.096);
            double d3 = Visible.gauss(1.06561, 5.00819E-4, d - 598.623) + Visible.gauss(0.283831, 0.00292745, d - 435.734) + Visible.gauss(0.113771, 0.00192849, d - 549.271) + Visible.gauss(0.239103, 0.00255944, d - 460.547);
            double d4 = Visible.gauss(0.239617, 0.00117296, d - 530.517) + Visible.gauss(0.910377, 3.00984E-4, d - 565.635) + Visible.gauss(0.0311013, 0.00152386, d - 463.833);
            double d5 = Visible.gauss(0.988366, 0.00220336, d - 456.345) + Visible.gauss(0.381551, 8.48554E-4, d - 450.871) + Visible.gauss(0.355693, 6.28546E-4, d - 470.668) + Visible.gauss(0.81862, 0.00471059, d - 433.144);
            double d6 = coordinateArray[n].getYVal();
            if (bl) {
                d6 = Math.pow(10.0, -Math.max(d6, 0.0));
            }
            dArray[0] = dArray[0] + d6 * d3 * d2;
            dArray[1] = dArray[1] + d6 * d4 * d2;
            dArray[2] = dArray[2] + d6 * d5 * d2;
            dArray[3] = dArray[3] + d4 * d2;
        }
    }

    private static double gauss(double d, double d2, double d3) {
        return d * Math.exp(-d2 * d3 * d3);
    }
}

