/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.api.GenericOutputChannel;
import javajs.util.BC;
import javajs.util.SB;

public class BinaryDocument
extends BC
implements GenericBinaryDocument {
    protected DataInputStream stream;
    protected boolean isRandom = false;
    protected boolean isBigEndian = true;
    protected BufferedInputStream bis;
    protected long nBytes;
    protected GenericOutputChannel out;
    byte[] t8 = new byte[8];

    @Override
    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.out != null) {
            this.out.closeChannel();
        }
    }

    @Override
    public BinaryDocument setStream(BufferedInputStream bis, boolean isBigEndian) {
        this.bis = bis;
        if (bis != null) {
            this.stream = new DataInputStream(bis);
        }
        this.isBigEndian = isBigEndian;
        return this;
    }

    @Override
    public BufferedInputStream getInputStream() {
        return this.bis;
    }

    @Override
    public void setStreamData(DataInputStream stream, boolean isBigEndian) {
        if (stream != null) {
            this.stream = stream;
        }
        this.isBigEndian = isBigEndian;
    }

    @Override
    public void setOutputChannel(GenericOutputChannel out) {
        this.out = out;
    }

    public void setRandom(boolean TF) {
        this.isRandom = TF;
    }

    @Override
    public byte readByte() throws IOException {
        ++this.nBytes;
        return this.ioReadByte();
    }

    @Override
    public int readUInt8() throws IOException {
        ++this.nBytes;
        int b = this.stream.readUnsignedByte();
        if (this.out != null) {
            this.out.writeByteAsInt(b);
        }
        return b;
    }

    private byte ioReadByte() throws IOException {
        byte b = this.stream.readByte();
        if (this.out != null) {
            this.out.writeByteAsInt(b);
        }
        return b;
    }

    @Override
    public byte[] readBytes(int n) throws IOException {
        byte[] b = new byte[n];
        this.readByteArray(b, 0, n);
        return b;
    }

    @Override
    public int readByteArray(byte[] b, int off, int len) throws IOException {
        int n = this.ioRead(b, off, len);
        this.nBytes += (long)n;
        return n;
    }

    private int ioRead(byte[] b, int off, int len) throws IOException {
        int m = 0;
        while (len > 0) {
            int n = this.stream.read(b, off, len);
            m += n;
            if (n > 0 && this.out != null) {
                this.out.write(b, off, n);
            }
            if (n >= len) break;
            off += n;
            len -= n;
        }
        return m;
    }

    @Override
    public String readString(int nChar) throws IOException {
        byte[] temp = new byte[nChar];
        int n = this.readByteArray(temp, 0, nChar);
        return new String(temp, 0, n, "UTF-8");
    }

    @Override
    public short readShort() throws IOException {
        this.nBytes += 2L;
        short n = this.isBigEndian ? this.ioReadShort() : (short)(this.ioReadByte() & 0xFF | (this.ioReadByte() & 0xFF) << 8);
        return n;
    }

    private short ioReadShort() throws IOException {
        short b = this.stream.readShort();
        if (this.out != null) {
            this.out.writeShort(b);
        }
        return b;
    }

    @Override
    public int readIntLE() throws IOException {
        this.nBytes += 4L;
        return this.readLEInt();
    }

    @Override
    public int readInt() throws IOException {
        this.nBytes += 4L;
        return this.isBigEndian ? this.ioReadInt() : this.readLEInt();
    }

    private int ioReadInt() throws IOException {
        int i = this.stream.readInt();
        if (this.out != null) {
            this.out.writeInt(i);
        }
        return i;
    }

    @Override
    public int swapBytesI(int n) {
        return n >> 24 & 0xFF | (n >> 16 & 0xFF) << 8 | (n >> 8 & 0xFF) << 16 | (n & 0xFF) << 24;
    }

    @Override
    public short swapBytesS(short n) {
        return (short)(n >> 8 & 0xFF | (n & 0xFF) << 8);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.nBytes += 2L;
        int a = this.ioReadByte() & 0xFF;
        int b = this.ioReadByte() & 0xFF;
        return this.isBigEndian ? (a << 8) + b : (b << 8) + a;
    }

    @Override
    public long readLong() throws IOException {
        this.nBytes += 8L;
        return this.isBigEndian ? this.ioReadLong() : (long)this.ioReadByte() & 0xFFL | ((long)this.ioReadByte() & 0xFFL) << 8 | ((long)this.ioReadByte() & 0xFFL) << 16 | ((long)this.ioReadByte() & 0xFFL) << 24 | ((long)this.ioReadByte() & 0xFFL) << 32 | ((long)this.ioReadByte() & 0xFFL) << 40 | ((long)this.ioReadByte() & 0xFFL) << 48 | ((long)this.ioReadByte() & 0xFFL) << 54;
    }

    private long ioReadLong() throws IOException {
        long b = this.stream.readLong();
        if (this.out != null) {
            this.out.writeLong(b);
        }
        return b;
    }

    private int readLEInt() throws IOException {
        this.ioRead(this.t8, 0, 4);
        return BinaryDocument.bytesToInt(this.t8, 0, false);
    }

    @Override
    public float readFloat() throws Exception {
        return BinaryDocument.intToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        this.nBytes += 8L;
        return this.isBigEndian ? this.ioReadDouble() : Double.longBitsToDouble(this.readLELong());
    }

    private double ioReadDouble() throws IOException {
        double d = this.stream.readDouble();
        if (this.out != null) {
            this.out.writeLong(Double.doubleToRawLongBits(d));
        }
        return d;
    }

    private long readLELong() throws IOException {
        return (long)this.ioReadByte() & 0xFFL | ((long)this.ioReadByte() & 0xFFL) << 8 | ((long)this.ioReadByte() & 0xFFL) << 16 | ((long)this.ioReadByte() & 0xFFL) << 24 | ((long)this.ioReadByte() & 0xFFL) << 32 | ((long)this.ioReadByte() & 0xFFL) << 40 | ((long)this.ioReadByte() & 0xFFL) << 48 | ((long)this.ioReadByte() & 0xFFL) << 56;
    }

    @Override
    public void seek(long offset) {
        try {
            if (offset == this.nBytes) {
                return;
            }
            if (offset < this.nBytes) {
                this.stream.reset();
                if (this.out != null && this.nBytes != 0L) {
                    this.out.reset();
                }
                this.nBytes = 0L;
            } else {
                offset -= this.nBytes;
            }
            if (this.out == null) {
                this.stream.skipBytes((int)offset);
            } else {
                this.readByteArray(new byte[(int)offset], 0, (int)offset);
            }
            this.nBytes += offset;
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    @Override
    public long getPosition() {
        return this.nBytes;
    }

    @Override
    public SB getAllDataFiles(String binaryFileList, String firstFile) {
        return null;
    }

    @Override
    public void getAllDataMapped(String replace, String string, Map<String, String> fileData) {
    }
}

