/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.PT;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class CubeReader
extends AtomSetCollectionReader {
    private int ac;
    private boolean isAngstroms = false;

    @Override
    public void initializeReader() throws Exception {
        this.asc.newAtomSet();
        this.readTitleLines();
        this.readAtomCountAndOrigin();
        this.readLines(3);
        this.readAtoms();
        this.applySymmetryAndSetTrajectory();
        this.continuing = false;
    }

    private void readTitleLines() throws Exception {
        if (this.rd().indexOf("#JVXL") == 0) {
            while (this.rd().indexOf("#") == 0) {
            }
        }
        this.checkCurrentLineForScript();
        String name = this.line.trim();
        this.rd();
        this.checkCurrentLineForScript();
        this.asc.setAtomSetName(name + " - " + this.line.trim());
    }

    private void readAtomCountAndOrigin() throws Exception {
        this.rd();
        this.isAngstroms = this.line.indexOf("ANGSTROMS") >= 0;
        String[] tokens = this.getTokens();
        if (tokens[0].charAt(0) == '+') {
            tokens[0] = tokens[0].substring(1);
        }
        this.ac = Math.abs(this.parseIntStr(tokens[0]));
    }

    private void readAtoms() throws Exception {
        float f = this.isAngstroms ? 1.0f : 0.5291772f;
        for (int i = 0; i < this.ac; ++i) {
            String[] tokens = PT.getTokens(this.rd());
            this.setAtomCoordScaled(null, (String[])tokens, (int)2, (float)f).elementNumber = (short)this.parseIntStr(tokens[0]);
        }
    }
}

