/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.serialization;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.io.ObjectInputStreamClassLoaderAware;
import org.apache.commons.jcs.utils.zip.CompressionUtil;

public class CompressingSerializer
implements IElementSerializer {
    @Override
    public <T> byte[] serialize(T obj) throws IOException {
        byte[] uncompressed = this.serializeObject(obj);
        byte[] compressed = CompressionUtil.compressByteArray(uncompressed);
        return compressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> byte[] serializeObject(T obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(obj);
        }
        byte[] uncompressed = baos.toByteArray();
        return uncompressed;
    }

    @Override
    public <T> T deSerialize(byte[] data, ClassLoader loader) throws IOException, ClassNotFoundException {
        if (data == null) {
            return null;
        }
        byte[] decompressedByteArray = CompressionUtil.decompressByteArray(data);
        return this.deserializeObject(decompressedByteArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T deserializeObject(byte[] decompressedByteArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(decompressedByteArray);
        BufferedInputStream bis = new BufferedInputStream(bais);
        try (ObjectInputStreamClassLoaderAware ois = new ObjectInputStreamClassLoaderAware(bis, null);){
            Object readObject;
            Object object = readObject = ois.readObject();
            return (T)object;
        }
    }
}

