/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.tools.I18n;

public class Sinusoidal
extends AbstractProj {
    @Override
    public String getName() {
        return I18n.tr("Sinusoidal", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "sinu";
    }

    @Override
    public double[] project(double phi, double lambda) {
        if (this.spherical) {
            return new double[]{lambda * Math.cos(phi), phi};
        }
        double s = Math.sin(phi);
        return new double[]{lambda * Math.cos(phi) / Math.sqrt(1.0 - this.e2 * s * s), this.mlfn(phi, s, Math.cos(phi))};
    }

    @Override
    public double[] invproject(double east, double north) {
        double lambda;
        if (this.spherical) {
            return new double[]{north, east / Math.cos(north)};
        }
        double phi = this.invMlfn(north);
        double s = Math.abs(phi);
        if (Math.abs(s - 1.5707963267948966) < 1.0E-10) {
            lambda = 0.0;
        } else if (s < 1.5707963267948966) {
            s = Math.sin(phi);
            lambda = east * Math.sqrt(1.0 - this.e2 * s * s) / Math.cos(phi) % Math.PI;
        } else {
            return new double[]{0.0, 0.0};
        }
        return new double[]{phi, lambda};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-90.0, -180.0, 90.0, 180.0, false);
    }
}

