/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class DisableShortcutsOnFocusGainedTextField
extends JosmTextField {
    private final transient List<Pair<Action, Shortcut>> unregisteredActionShortcuts = new ArrayList<Pair<Action, Shortcut>>();
    private final Set<JosmAction> disabledMenuActions = new HashSet<JosmAction>();

    public DisableShortcutsOnFocusGainedTextField() {
    }

    public DisableShortcutsOnFocusGainedTextField(String text) {
        super(text);
    }

    public DisableShortcutsOnFocusGainedTextField(int columns) {
        super(columns);
    }

    public DisableShortcutsOnFocusGainedTextField(String text, int columns) {
        super(text, columns);
    }

    public DisableShortcutsOnFocusGainedTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        this.disableMenuActions();
        this.unregisterActionShortcuts();
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        this.restoreActionShortcuts();
        this.restoreMenuActions();
    }

    protected void disableMenuActions() {
        this.disabledMenuActions.clear();
        for (int i = 0; i < MainApplication.getMenu().getMenuCount(); ++i) {
            JMenu menu = MainApplication.getMenu().getMenu(i);
            if (menu == null) continue;
            for (int j = 0; j < menu.getItemCount(); ++j) {
                KeyStroke ks;
                Shortcut shortcut;
                Action action;
                JMenuItem item = menu.getItem(j);
                if (item == null || !((action = item.getAction()) instanceof JosmAction) || !action.isEnabled() || (shortcut = ((JosmAction)action).getShortcut()) == null || !this.hasToBeDisabled(ks = shortcut.getKeyStroke())) continue;
                action.setEnabled(false);
                this.disabledMenuActions.add((JosmAction)action);
            }
        }
    }

    protected void unregisterActionShortcuts() {
        this.unregisteredActionShortcuts.clear();
        for (Shortcut shortcut : Shortcut.listAll()) {
            Action action;
            KeyStroke ks = shortcut.getKeyStroke();
            if (!this.hasToBeDisabled(ks) || (action = MainApplication.getRegisteredActionShortcut(shortcut)) == null) continue;
            MainApplication.unregisterActionShortcut(action, shortcut);
            this.unregisteredActionShortcuts.add(new Pair<Action, Shortcut>(action, shortcut));
        }
    }

    protected boolean hasToBeDisabled(KeyStroke ks) {
        return ks != null && ks.getModifiers() == 0 && !new KeyEvent(this, 401, 0L, ks.getModifiers(), ks.getKeyCode(), ks.getKeyChar()).isActionKey();
    }

    protected void restoreMenuActions() {
        for (JosmAction a : this.disabledMenuActions) {
            a.setEnabled(true);
        }
        this.disabledMenuActions.clear();
    }

    protected void restoreActionShortcuts() {
        for (Pair<Action, Shortcut> p : this.unregisteredActionShortcuts) {
            MainApplication.registerActionShortcut((Action)p.a, (Shortcut)p.b);
        }
        this.unregisteredActionShortcuts.clear();
    }
}

