/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.tools.I18n;

public enum OnlineResource {
    OSM_API(I18n.tr("OSM API", new Object[0])),
    JOSM_WEBSITE(I18n.tr("JOSM website", new Object[0])),
    ALL(I18n.tr("All", new Object[0]));

    private final String locName;

    private OnlineResource(String locName) {
        this.locName = locName;
    }

    public final String getLocName() {
        return this.locName;
    }

    public final void checkOfflineAccess(String downloadString, String resourceString) {
        if (Main.isOffline(this) && downloadString.substring(downloadString.indexOf("://")).startsWith(resourceString.substring(resourceString.indexOf("://")))) {
            throw new OfflineAccessException(I18n.tr("Unable to access ''{0}'': {1} not available (offline mode)", downloadString, this.getLocName()));
        }
    }
}

