/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImageryReader
implements Closeable {
    private final String source;
    private CachedFile cachedFile;
    private boolean fastFail;

    public ImageryReader(String source) {
        this.source = source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ImageryInfo> parse() throws SAXException, IOException {
        Parser parser = new Parser();
        try {
            this.cachedFile = new CachedFile(this.source);
            this.cachedFile.setFastFail(this.fastFail);
            try (BufferedReader in = this.cachedFile.setMaxAge(CachedFile.DAYS).setCachingStrategy(CachedFile.CachingStrategy.IfModifiedSince).getContentReader();){
                InputSource is = new InputSource(in);
                Utils.parseSafeSAX(is, parser);
                List list = parser.entries;
                return list;
            }
        }
        catch (SAXException e) {
            throw e;
        }
        catch (ParserConfigurationException e) {
            Logging.error(e);
            throw new SAXException(e);
        }
    }

    public void setFastFail(boolean fastFail) {
        this.fastFail = fastFail;
    }

    @Override
    public void close() throws IOException {
        Utils.close(this.cachedFile);
    }

    private static class Parser
    extends DefaultHandler {
        private static final String MAX_ZOOM = "max-zoom";
        private static final String MIN_ZOOM = "min-zoom";
        private static final String TILE_SIZE = "tile-size";
        private static final String TRUE = "true";
        private StringBuilder accumulator = new StringBuilder();
        private Stack<State> states;
        private List<ImageryInfo> entries;
        private boolean skipEntry;
        private ImageryInfo entry;
        private ImageryInfo mirrorEntry;
        private ImageryInfo.ImageryBounds bounds;
        private Shape shape;
        private String lang;
        private List<String> projections;
        private MultiMap<String, String> noTileHeaders;
        private MultiMap<String, String> noTileChecksums;
        private Map<String, String> metadataHeaders;

        private Parser() {
        }

        @Override
        public void startDocument() {
            this.accumulator = new StringBuilder();
            this.skipEntry = false;
            this.states = new Stack();
            this.states.push(State.INIT);
            this.entries = new ArrayList<ImageryInfo>();
            this.entry = null;
            this.bounds = null;
            this.projections = null;
            this.noTileHeaders = null;
            this.noTileChecksums = null;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.accumulator.setLength(0);
            State newState = null;
            switch (this.states.peek()) {
                case INIT: {
                    if (!"imagery".equals(qName)) break;
                    newState = State.IMAGERY;
                    break;
                }
                case IMAGERY: {
                    if (!"entry".equals(qName)) break;
                    this.entry = new ImageryInfo();
                    this.skipEntry = false;
                    newState = State.ENTRY;
                    this.noTileHeaders = new MultiMap();
                    this.noTileChecksums = new MultiMap();
                    this.metadataHeaders = new HashMap<String, String>();
                    String best = atts.getValue("eli-best");
                    if (!TRUE.equals(best)) break;
                    this.entry.setBestMarked(true);
                    break;
                }
                case MIRROR: {
                    if (Arrays.asList("type", "url", MIN_ZOOM, MAX_ZOOM, TILE_SIZE).contains(qName)) {
                        newState = State.MIRROR_ATTRIBUTE;
                        this.lang = atts.getValue("lang");
                        break;
                    }
                    if (!"projections".equals(qName)) break;
                    this.projections = new ArrayList<String>();
                    newState = State.MIRROR_PROJECTIONS;
                    break;
                }
                case ENTRY: {
                    if (Arrays.asList("name", "id", "type", "description", "default", "url", "eula", MIN_ZOOM, MAX_ZOOM, "attribution-text", "attribution-url", "logo-image", "logo-url", "terms-of-use-text", "terms-of-use-url", "permission-ref", "country-code", "icon", "date", TILE_SIZE, "valid-georeference").contains(qName)) {
                        newState = State.ENTRY_ATTRIBUTE;
                        this.lang = atts.getValue("lang");
                        break;
                    }
                    if ("bounds".equals(qName)) {
                        try {
                            this.bounds = new ImageryInfo.ImageryBounds(atts.getValue("min-lat") + ',' + atts.getValue("min-lon") + ',' + atts.getValue("max-lat") + ',' + atts.getValue("max-lon"), ",");
                        }
                        catch (IllegalArgumentException e) {
                            Logging.trace(e);
                            break;
                        }
                        newState = State.BOUNDS;
                        break;
                    }
                    if ("projections".equals(qName)) {
                        this.projections = new ArrayList<String>();
                        newState = State.PROJECTIONS;
                        break;
                    }
                    if ("mirror".equals(qName)) {
                        this.projections = new ArrayList<String>();
                        newState = State.MIRROR;
                        this.mirrorEntry = new ImageryInfo();
                        break;
                    }
                    if ("no-tile-header".equals(qName)) {
                        this.noTileHeaders.put(atts.getValue("name"), atts.getValue("value"));
                        newState = State.NO_TILE;
                        break;
                    }
                    if ("no-tile-checksum".equals(qName)) {
                        this.noTileChecksums.put(atts.getValue("type"), atts.getValue("value"));
                        newState = State.NO_TILESUM;
                        break;
                    }
                    if (!"metadata-header".equals(qName)) break;
                    this.metadataHeaders.put(atts.getValue("header-name"), atts.getValue("metadata-key"));
                    newState = State.METADATA;
                    break;
                }
                case BOUNDS: {
                    if (!"shape".equals(qName)) break;
                    this.shape = new Shape();
                    newState = State.SHAPE;
                    break;
                }
                case SHAPE: {
                    if (!"point".equals(qName)) break;
                    try {
                        this.shape.addPoint(atts.getValue("lat"), atts.getValue("lon"));
                    }
                    catch (IllegalArgumentException e) {
                        Logging.trace(e);
                    }
                    break;
                }
                case PROJECTIONS: 
                case MIRROR_PROJECTIONS: {
                    if (!"code".equals(qName)) break;
                    newState = State.CODE;
                    break;
                }
            }
            if (newState == null) {
                newState = State.UNKNOWN;
            }
            this.states.push(newState);
            if (newState == State.UNKNOWN && TRUE.equals(atts.getValue("mandatory"))) {
                this.skipEntry = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.accumulator.append(ch, start, length);
        }

        @Override
        public void endElement(String namespaceURI, String qName, String rqName) {
            switch (this.states.pop()) {
                case INIT: {
                    throw new JosmRuntimeException("parsing error: more closing than opening elements");
                }
                case ENTRY: {
                    if (!"entry".equals(qName)) break;
                    this.entry.setNoTileHeaders(this.noTileHeaders);
                    this.noTileHeaders = null;
                    this.entry.setNoTileChecksums(this.noTileChecksums);
                    this.noTileChecksums = null;
                    this.entry.setMetadataHeaders(this.metadataHeaders);
                    this.metadataHeaders = null;
                    if (!this.skipEntry) {
                        this.entries.add(this.entry);
                    }
                    this.entry = null;
                    break;
                }
                case MIRROR: {
                    if (this.mirrorEntry == null || !"mirror".equals(qName)) break;
                    this.entry.addMirror(this.mirrorEntry);
                    this.mirrorEntry = null;
                    break;
                }
                case MIRROR_ATTRIBUTE: {
                    if (this.mirrorEntry == null) break;
                    switch (qName) {
                        case "type": {
                            boolean found = false;
                            for (ImageryInfo.ImageryType type : ImageryInfo.ImageryType.values()) {
                                if (!Objects.equals(this.accumulator.toString(), type.getTypeString())) continue;
                                this.mirrorEntry.setImageryType(type);
                                found = true;
                                break;
                            }
                            if (found) break;
                            this.mirrorEntry = null;
                            break;
                        }
                        case "url": {
                            this.mirrorEntry.setUrl(this.accumulator.toString());
                            break;
                        }
                        case "min-zoom": 
                        case "max-zoom": {
                            Integer val = null;
                            try {
                                val = Integer.valueOf(this.accumulator.toString());
                            }
                            catch (NumberFormatException e) {
                                val = null;
                            }
                            if (val == null) {
                                this.mirrorEntry = null;
                                break;
                            }
                            if (MIN_ZOOM.equals(qName)) {
                                this.mirrorEntry.setDefaultMinZoom(val);
                                break;
                            }
                            this.mirrorEntry.setDefaultMaxZoom(val);
                            break;
                        }
                        case "tile-size": {
                            Integer tileSize = null;
                            try {
                                tileSize = Integer.valueOf(this.accumulator.toString());
                            }
                            catch (NumberFormatException e) {
                                tileSize = null;
                            }
                            if (tileSize == null) {
                                this.mirrorEntry = null;
                                break;
                            }
                            this.entry.setTileSize(tileSize);
                            break;
                        }
                    }
                    break;
                }
                case ENTRY_ATTRIBUTE: {
                    block52 : switch (qName) {
                        case "name": {
                            this.entry.setName(this.lang == null ? LanguageInfo.getJOSMLocaleCode(null) : this.lang, this.accumulator.toString());
                            break;
                        }
                        case "description": {
                            this.entry.setDescription(this.lang, this.accumulator.toString());
                            break;
                        }
                        case "date": {
                            this.entry.setDate(this.accumulator.toString());
                            break;
                        }
                        case "id": {
                            this.entry.setId(this.accumulator.toString());
                            break;
                        }
                        case "type": {
                            boolean found = false;
                            for (ImageryInfo.ImageryType type : ImageryInfo.ImageryType.values()) {
                                if (!Objects.equals(this.accumulator.toString(), type.getTypeString())) continue;
                                this.entry.setImageryType(type);
                                found = true;
                                break;
                            }
                            if (found) break;
                            this.skipEntry = true;
                            break;
                        }
                        case "default": {
                            switch (this.accumulator.toString()) {
                                case "true": {
                                    this.entry.setDefaultEntry(true);
                                    break block52;
                                }
                                case "false": {
                                    this.entry.setDefaultEntry(false);
                                    break block52;
                                }
                            }
                            this.skipEntry = true;
                            break;
                        }
                        case "url": {
                            this.entry.setUrl(this.accumulator.toString());
                            break;
                        }
                        case "eula": {
                            this.entry.setEulaAcceptanceRequired(this.accumulator.toString());
                            break;
                        }
                        case "min-zoom": 
                        case "max-zoom": {
                            Integer val = null;
                            try {
                                val = Integer.valueOf(this.accumulator.toString());
                            }
                            catch (NumberFormatException e) {
                                val = null;
                            }
                            if (val == null) {
                                this.skipEntry = true;
                                break;
                            }
                            if (MIN_ZOOM.equals(qName)) {
                                this.entry.setDefaultMinZoom(val);
                                break;
                            }
                            this.entry.setDefaultMaxZoom(val);
                            break;
                        }
                        case "attribution-text": {
                            this.entry.setAttributionText(this.accumulator.toString());
                            break;
                        }
                        case "attribution-url": {
                            this.entry.setAttributionLinkURL(this.accumulator.toString());
                            break;
                        }
                        case "logo-image": {
                            this.entry.setAttributionImage(this.accumulator.toString());
                            break;
                        }
                        case "logo-url": {
                            this.entry.setAttributionImageURL(this.accumulator.toString());
                            break;
                        }
                        case "terms-of-use-text": {
                            this.entry.setTermsOfUseText(this.accumulator.toString());
                            break;
                        }
                        case "permission-ref": {
                            this.entry.setPermissionReferenceURL(this.accumulator.toString());
                            break;
                        }
                        case "terms-of-use-url": {
                            this.entry.setTermsOfUseURL(this.accumulator.toString());
                            break;
                        }
                        case "country-code": {
                            this.entry.setCountryCode(this.accumulator.toString());
                            break;
                        }
                        case "icon": {
                            this.entry.setIcon(this.accumulator.toString());
                            break;
                        }
                        case "tile-size": {
                            Integer tileSize = null;
                            try {
                                tileSize = Integer.valueOf(this.accumulator.toString());
                            }
                            catch (NumberFormatException e) {
                                tileSize = null;
                            }
                            if (tileSize == null) {
                                this.skipEntry = true;
                                break;
                            }
                            this.entry.setTileSize(tileSize);
                            break;
                        }
                        case "valid-georeference": {
                            this.entry.setGeoreferenceValid(Boolean.parseBoolean(this.accumulator.toString()));
                            break;
                        }
                    }
                    break;
                }
                case BOUNDS: {
                    this.entry.setBounds(this.bounds);
                    this.bounds = null;
                    break;
                }
                case SHAPE: {
                    this.bounds.addShape(this.shape);
                    this.shape = null;
                    break;
                }
                case CODE: {
                    this.projections.add(this.accumulator.toString());
                    break;
                }
                case PROJECTIONS: {
                    this.entry.setServerProjections(this.projections);
                    this.projections = null;
                    break;
                }
                case MIRROR_PROJECTIONS: {
                    this.mirrorEntry.setServerProjections(this.projections);
                    this.projections = null;
                    break;
                }
            }
        }
    }

    private static enum State {
        INIT,
        IMAGERY,
        ENTRY,
        ENTRY_ATTRIBUTE,
        PROJECTIONS,
        MIRROR,
        MIRROR_ATTRIBUTE,
        MIRROR_PROJECTIONS,
        CODE,
        BOUNDS,
        SHAPE,
        NO_TILE,
        NO_TILESUM,
        METADATA,
        UNKNOWN;

    }
}

