/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.HashMap;
import java.util.Map;

public class Diff {
    private int equivMax = 1;
    private int[] xvec;
    private int[] yvec;
    private int[] fdiag;
    private int[] bdiag;
    private int fdiagoff;
    private int bdiagoff;
    private final FileData[] filevec;
    private int cost;
    public static final ScriptBuilder forwardScript = new ForwardScript();
    public static final ScriptBuilder reverseScript = new ReverseScript();

    public Diff(Object[] a, Object[] b) {
        HashMap<Object, Integer> h = new HashMap<Object, Integer>(a.length + b.length);
        this.filevec = new FileData[]{new FileData(a, h), new FileData(b, h)};
    }

    private int diag(int xoff, int xlim, int yoff, int ylim) {
        int[] fd = this.fdiag;
        int[] bd = this.bdiag;
        int[] xv = this.xvec;
        int[] yv = this.yvec;
        int dmin = xoff - ylim;
        int dmax = xlim - yoff;
        int fmid = xoff - yoff;
        int bmid = xlim - ylim;
        int fmin = fmid;
        int fmax = fmid;
        int bmin = bmid;
        int bmax = bmid;
        boolean odd = (fmid - bmid & 1) != 0;
        fd[this.fdiagoff + fmid] = xoff;
        bd[this.bdiagoff + bmid] = xlim;
        int c = 1;
        while (true) {
            int y;
            int x;
            int thi;
            int tlo;
            int d;
            if (fmin > dmin) {
                fd[this.fdiagoff + --fmin - 1] = -1;
            } else {
                ++fmin;
            }
            if (fmax < dmax) {
                fd[this.fdiagoff + ++fmax + 1] = -1;
            } else {
                --fmax;
            }
            for (d = fmax; d >= fmin; d -= 2) {
                tlo = fd[this.fdiagoff + d - 1];
                thi = fd[this.fdiagoff + d + 1];
                x = tlo >= thi ? tlo + 1 : thi;
                for (y = x - d; x < xlim && y < ylim && xv[x] == yv[y]; ++x, ++y) {
                }
                fd[this.fdiagoff + d] = x;
                if (!odd || bmin > d || d > bmax || bd[this.bdiagoff + d] > fd[this.fdiagoff + d]) continue;
                this.cost = 2 * c - 1;
                return d;
            }
            if (bmin > dmin) {
                bd[this.bdiagoff + --bmin - 1] = Integer.MAX_VALUE;
            } else {
                ++bmin;
            }
            if (bmax < dmax) {
                bd[this.bdiagoff + ++bmax + 1] = Integer.MAX_VALUE;
            } else {
                --bmax;
            }
            for (d = bmax; d >= bmin; d -= 2) {
                tlo = bd[this.bdiagoff + d - 1];
                thi = bd[this.bdiagoff + d + 1];
                x = tlo < thi ? tlo : thi - 1;
                for (y = x - d; x > xoff && y > yoff && xv[x - 1] == yv[y - 1]; --x, --y) {
                }
                bd[this.bdiagoff + d] = x;
                if (odd || fmin > d || d > fmax || bd[this.bdiagoff + d] > fd[this.fdiagoff + d]) continue;
                this.cost = 2 * c;
                return d;
            }
            ++c;
        }
    }

    private void compareseq(int xoff, int xlim, int yoff, int ylim) {
        while (xoff < xlim && yoff < ylim && this.xvec[xoff] == this.yvec[yoff]) {
            ++xoff;
            ++yoff;
        }
        while (xlim > xoff && ylim > yoff && this.xvec[xlim - 1] == this.yvec[ylim - 1]) {
            --xlim;
            --ylim;
        }
        if (xoff == xlim) {
            while (yoff < ylim) {
                ((FileData)this.filevec[1]).changedFlag[1 + ((FileData)this.filevec[1]).realindexes[yoff++]] = true;
            }
        } else if (yoff == ylim) {
            while (xoff < xlim) {
                ((FileData)this.filevec[0]).changedFlag[1 + ((FileData)this.filevec[0]).realindexes[xoff++]] = true;
            }
        } else {
            int d = this.diag(xoff, xlim, yoff, ylim);
            int c = this.cost;
            int b = this.bdiag[this.bdiagoff + d];
            if (c == 1) {
                throw new IllegalArgumentException("Empty subsequence");
            }
            this.compareseq(xoff, b, yoff, b - d);
            this.compareseq(b, xlim, b - d, ylim);
        }
    }

    private void discardConfusingLines() {
        this.filevec[0].discardConfusingLines(this.filevec[1]);
        this.filevec[1].discardConfusingLines(this.filevec[0]);
    }

    private void shiftBoundaries() {
        this.filevec[0].shiftBoundaries(this.filevec[1]);
        this.filevec[1].shiftBoundaries(this.filevec[0]);
    }

    public final Change diff2(boolean reverse) {
        return this.diff(reverse ? reverseScript : forwardScript);
    }

    public Change diff(ScriptBuilder bld) {
        this.discardConfusingLines();
        this.xvec = this.filevec[0].undiscarded;
        this.yvec = this.filevec[1].undiscarded;
        int diags = this.filevec[0].nondiscardedLines + this.filevec[1].nondiscardedLines + 3;
        this.fdiag = new int[diags];
        this.fdiagoff = this.filevec[1].nondiscardedLines + 1;
        this.bdiag = new int[diags];
        this.bdiagoff = this.filevec[1].nondiscardedLines + 1;
        this.compareseq(0, this.filevec[0].nondiscardedLines, 0, this.filevec[1].nondiscardedLines);
        this.fdiag = null;
        this.bdiag = null;
        this.shiftBoundaries();
        return bld.buildScript(this.filevec[0].changedFlag, this.filevec[0].bufferedLines, this.filevec[1].changedFlag, this.filevec[1].bufferedLines);
    }

    class FileData {
        private final int bufferedLines;
        private final int[] equivs;
        private final int[] undiscarded;
        private final int[] realindexes;
        private int nondiscardedLines;
        private boolean[] changedFlag;

        void clear() {
            this.changedFlag = new boolean[this.bufferedLines + 2];
        }

        int[] equivCount() {
            int[] equivCount = new int[Diff.this.equivMax];
            for (int i = 0; i < this.bufferedLines; ++i) {
                int n = this.equivs[i];
                equivCount[n] = equivCount[n] + 1;
            }
            return equivCount;
        }

        void discardConfusingLines(FileData f) {
            this.clear();
            byte[] discarded = this.discardable(f.equivCount());
            this.filterDiscards(discarded);
            this.discard(discarded);
        }

        private byte[] discardable(int ... counts) {
            int end = this.bufferedLines;
            byte[] discards = new byte[end];
            int[] equivs = this.equivs;
            int many = 5;
            int tem = end / 64;
            while ((tem >>= 2) > 0) {
                many *= 2;
            }
            for (int i = 0; i < end; ++i) {
                if (equivs[i] == 0) continue;
                int nmatch = counts[equivs[i]];
                if (nmatch == 0) {
                    discards[i] = 1;
                    continue;
                }
                if (nmatch <= many) continue;
                discards[i] = 2;
            }
            return discards;
        }

        private void filterDiscards(byte[] discards) {
            int end = this.bufferedLines;
            block0: for (int i = 0; i < end; ++i) {
                int j;
                if (discards[i] == 2) {
                    discards[i] = 0;
                    continue;
                }
                if (discards[i] == 0) continue;
                int provisional = 0;
                for (j = i; j < end && discards[j] != 0; ++j) {
                    if (discards[j] != 2) continue;
                    ++provisional;
                }
                while (j > i && discards[j - 1] == 2) {
                    discards[--j] = 0;
                    --provisional;
                }
                int length = j - i;
                if (provisional * 4 > length) {
                    while (j > i) {
                        if (discards[--j] != 2) continue;
                        discards[j] = 0;
                    }
                    continue;
                }
                int minimum = 1;
                int tem = length / 4;
                while ((tem >>= 2) > 0) {
                    minimum *= 2;
                }
                ++minimum;
                int consec = 0;
                for (j = 0; j < length; ++j) {
                    if (discards[i + j] != 2) {
                        consec = 0;
                        continue;
                    }
                    if (minimum == ++consec) {
                        j -= consec;
                        continue;
                    }
                    if (minimum >= consec) continue;
                    discards[i + j] = 0;
                }
                consec = 0;
                for (j = 0; j < length && (j < 8 || discards[i + j] != 1); ++j) {
                    if (discards[i + j] == 2) {
                        consec = 0;
                        discards[i + j] = 0;
                    } else {
                        consec = discards[i + j] == 0 ? 0 : ++consec;
                    }
                    if (consec == 3) break;
                }
                i += length - 1;
                consec = 0;
                for (j = 0; j < length && (j < 8 || discards[i - j] != 1); ++j) {
                    if (discards[i - j] == 2) {
                        consec = 0;
                        discards[i - j] = 0;
                    } else {
                        consec = discards[i - j] == 0 ? 0 : ++consec;
                    }
                    if (consec == 3) continue block0;
                }
            }
        }

        private void discard(byte[] discards) {
            int end = this.bufferedLines;
            int j = 0;
            for (int i = 0; i < end; ++i) {
                if (discards[i] == 0) {
                    this.undiscarded[j] = this.equivs[i];
                    this.realindexes[j++] = i;
                    continue;
                }
                this.changedFlag[1 + i] = true;
            }
            this.nondiscardedLines = j;
        }

        FileData(int length) {
            this.bufferedLines = length;
            this.equivs = new int[length];
            this.undiscarded = new int[this.bufferedLines];
            this.realindexes = new int[this.bufferedLines];
        }

        FileData(Object[] data, Map<Object, Integer> h) {
            this(data.length);
            for (int i = 0; i < data.length; ++i) {
                Integer ir = h.get(data[i]);
                if (ir == null) {
                    this.equivs[i] = this$0.equivMax++;
                    h.put(data[i], this.equivs[i]);
                    continue;
                }
                this.equivs[i] = ir;
            }
        }

        void shiftBoundaries(FileData f) {
            boolean[] changed = this.changedFlag;
            boolean[] otherChanged = f.changedFlag;
            int i = 0;
            int j = 0;
            int iEnd = this.bufferedLines;
            int preceding = -1;
            int otherPreceding = -1;
            while (true) {
                if (i < iEnd && !changed[1 + i]) {
                    while (otherChanged[1 + j++]) {
                        otherPreceding = j;
                    }
                    ++i;
                    continue;
                }
                if (i == iEnd) break;
                int start = i;
                int otherStart = j;
                boolean loop = true;
                while (loop) {
                    while (i < iEnd && changed[1 + i]) {
                        ++i;
                    }
                    int end = i;
                    if (!(end == iEnd || this.equivs[start] != this.equivs[end] || otherChanged[1 + j] || preceding >= 0 && start == preceding || otherPreceding >= 0 && otherStart == otherPreceding)) {
                        changed[1 + end] = true;
                        changed[1 + start++] = false;
                        ++i;
                        ++j;
                        continue;
                    }
                    loop = false;
                }
                preceding = i;
                otherPreceding = j;
            }
        }
    }

    public static class Change {
        public Change link;
        public final int inserted;
        public final int deleted;
        public final int line0;
        public final int line1;

        public Change(int line0, int line1, int deleted, int inserted, Change old) {
            this.line0 = line0;
            this.line1 = line1;
            this.inserted = inserted;
            this.deleted = deleted;
            this.link = old;
        }

        public int getTotalNumberOfChanges() {
            return this.inserted + this.deleted + (this.link != null ? this.link.getTotalNumberOfChanges() : 0);
        }

        public String toString() {
            String s = String.format("%d -%d +%d %d", this.line0, this.deleted, this.inserted, this.line1);
            return this.link != null ? s + '\n' + this.link : s;
        }
    }

    static class ForwardScript
    implements ScriptBuilder {
        ForwardScript() {
        }

        @Override
        public Change buildScript(boolean[] changed0, int len0, boolean[] changed1, int len1) {
            Change script = null;
            int i0 = len0;
            for (int i1 = len1; i0 >= 0 || i1 >= 0; --i0, --i1) {
                if (!changed0[i0] && !changed1[i1]) continue;
                int line0 = i0;
                int line1 = i1;
                while (changed0[i0]) {
                    --i0;
                }
                while (changed1[i1]) {
                    --i1;
                }
                script = new Change(i0, i1, line0 - i0, line1 - i1, script);
            }
            return script;
        }
    }

    static class ReverseScript
    implements ScriptBuilder {
        ReverseScript() {
        }

        @Override
        public Change buildScript(boolean[] changed0, int len0, boolean[] changed1, int len1) {
            Change script = null;
            int i0 = 0;
            for (int i1 = 0; i0 < len0 || i1 < len1; ++i0, ++i1) {
                if (!changed0[1 + i0] && !changed1[1 + i1]) continue;
                int line0 = i0;
                int line1 = i1;
                while (changed0[1 + i0]) {
                    ++i0;
                }
                while (changed1[1 + i1]) {
                    ++i1;
                }
                script = new Change(line0, line1, i0 - line0, i1 - line1, script);
            }
            return script;
        }
    }

    @FunctionalInterface
    public static interface ScriptBuilder {
        public Change buildScript(boolean[] var1, int var2, boolean[] var3, int var4);
    }
}

