/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;
import org.jruby.anno.AnnotationHelper;
import org.jruby.anno.ExecutableElementDescriptor;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DescriptorInfo;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.commons.Method;
import org.jruby.runtime.Visibility;
import org.jruby.util.CodegenUtils;

@SupportedAnnotationTypes(value={"org.jruby.anno.JRubyMethod"})
public class IndyBinder
extends AbstractProcessor {
    public static final String POPULATOR_SUFFIX = "$POPULATOR";
    public static final String SRC_GEN_DIR = "target/classes/org/jruby/gen/";
    public static final int CLASS = 1;
    public static final int BASEMETHOD = 3;
    public static final int MODULEMETHOD = 4;
    public static final int RUNTIME = 5;
    public static final int SINGLETONCLASS = 6;
    public static final int RUBYMODULE = 1;
    private final List<CharSequence> classNames = new ArrayList<CharSequence>();
    private SkinnyMethodAdapter mv;
    private static final boolean DEBUG = false;
    private static final int MAX_ENCODED_ARGS_EXPONENT = 8;
    private static final int MAX_ENCODED_ARGS_MASK = 255;
    private static final int ENCODE_RESTKWARGS_SHIFT = 0;
    private static final int ENCODE_REST_SHIFT = 1;
    private static final int ENCODE_REQKWARGS_SHIFT = 9;
    private static final int ENCODE_KWARGS_SHIFT = 17;
    private static final int ENCODE_POST_SHIFT = 25;
    private static final int ENCODE_OPT_SHIFT = 33;
    private static final int ENCODE_PRE_SHIFT = 41;

    @Override
    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnvironment) {
        for (TypeElement element : ElementFilter.typesIn(roundEnvironment.getRootElements())) {
            this.processType(element);
        }
        try {
            FileWriter fw = new FileWriter("target/generated-sources/annotated_classes.txt");
            for (CharSequence name2 : this.classNames) {
                fw.write(name2.toString());
                fw.write(10);
            }
            fw.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - void declaration
     */
    public void processType(TypeElement cd) {
        for (TypeElement innerType : ElementFilter.typesIn(cd.getEnclosedElements())) {
            this.processType(innerType);
        }
        try {
            String qualifiedName = cd.getQualifiedName().toString().replace('.', '$');
            if (!qualifiedName.contains("org$jruby")) {
                return;
            }
            ClassWriter cw = new ClassWriter(3);
            cw.visitAnnotation(CodegenUtils.p(Generated.class), true);
            cw.visit(51, 1, ("org.jruby.gen." + qualifiedName + POPULATOR_SUFFIX).replace('.', '/'), null, "org/jruby/anno/TypePopulator", null);
            this.mv = new SkinnyMethodAdapter(cw, 1, "<init>", "()V", null, null);
            this.mv.start();
            this.mv.aload(0);
            this.mv.invokespecial("org/jruby/anno/TypePopulator", "<init>", "()V");
            this.mv.voidreturn();
            this.mv.end();
            this.mv = new SkinnyMethodAdapter(cw, 1, "populate", "(Lorg/jruby/RubyModule;Ljava/lang/Class;)V", null, null);
            this.mv.start();
            boolean hasAnno = false;
            boolean hasMeta = false;
            boolean hasModule = false;
            for (ExecutableElement method : ElementFilter.methodsIn(cd.getEnclosedElements())) {
                JRubyMethod anno = method.getAnnotation(JRubyMethod.class);
                if (anno == null) continue;
                hasAnno = true;
                hasMeta |= anno.meta();
                hasModule |= anno.module();
            }
            if (!hasAnno) {
                return;
            }
            this.mv.aload(1);
            this.mv.invokevirtual("org/jruby/RubyModule", "getRuntime", "()Lorg/jruby/Ruby;");
            this.mv.astore(5);
            if (hasMeta || hasModule) {
                this.mv.aload(1);
                this.mv.invokevirtual("org/jruby/RubyModule", "getSingletonClass", "()Lorg/jruby/RubyClass;");
                this.mv.astore(6);
            }
            HashMap<CharSequence, List<ExecutableElement>> annotatedMethods = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> staticAnnotatedMethods = new HashMap<CharSequence, List<ExecutableElement>>();
            HashSet<String> frameAwareMethods = null;
            HashSet<String> scopeAwareMethods = null;
            int methodCount = 0;
            for (ExecutableElement executableElement : ElementFilter.methodsIn(cd.getEnclosedElements())) {
                void var17_37;
                String[] names2;
                CharSequence name2;
                JRubyMethod jRubyMethod = executableElement.getAnnotation(JRubyMethod.class);
                if (jRubyMethod == null) continue;
                ++methodCount;
                if (executableElement.getThrownTypes().size() != 0) {
                    System.err.print("Method " + cd.toString() + "." + executableElement.toString() + " should not throw exceptions: ");
                    boolean comma = false;
                    for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
                        if (comma) {
                            System.err.print(", ");
                        }
                        System.err.print(typeMirror);
                        comma = true;
                    }
                    System.err.print("\n");
                }
                CharSequence charSequence = name2 = (names2 = jRubyMethod.name()).length == 0 ? executableElement.getSimpleName() : names2[0];
                if (executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
                    HashMap<CharSequence, List<ExecutableElement>> hashMap = staticAnnotatedMethods;
                } else {
                    HashMap<CharSequence, List<ExecutableElement>> hashMap = annotatedMethods;
                }
                ArrayList<ExecutableElement> methodDescs = (ArrayList<ExecutableElement>)var17_37.get(name2);
                if (methodDescs == null) {
                    methodDescs = new ArrayList<ExecutableElement>(4);
                    var17_37.put(name2, methodDescs);
                }
                methodDescs.add(executableElement);
                boolean frame = false;
                boolean scope = false;
                for (FrameField field2 : jRubyMethod.reads()) {
                    frame |= field2.needsFrame();
                    scope |= field2.needsScope();
                }
                for (FrameField field2 : jRubyMethod.writes()) {
                    frame |= field2.needsFrame();
                    scope |= field2.needsScope();
                }
                if (frame) {
                    if (frameAwareMethods == null) {
                        frameAwareMethods = new HashSet<String>(4, 1.0f);
                    }
                    AnnotationHelper.addMethodNamesToSet(frameAwareMethods, executableElement.getSimpleName().toString(), names2, jRubyMethod.alias());
                }
                if (!scope) continue;
                if (scopeAwareMethods == null) {
                    scopeAwareMethods = new HashSet<String>(4, 1.0f);
                }
                AnnotationHelper.addMethodNamesToSet(scopeAwareMethods, executableElement.getSimpleName().toString(), names2, jRubyMethod.alias());
            }
            if (methodCount == 0) {
                return;
            }
            this.classNames.add(IndyBinder.getActualQualifiedName(cd));
            this.processMethodDeclarations(staticAnnotatedMethods);
            for (Map.Entry entry : staticAnnotatedMethods.entrySet()) {
                ExecutableElement executableElement = (ExecutableElement)((List)entry.getValue()).get(0);
                if (executableElement.getAnnotation(JRubyMethod.class).omit()) continue;
                this.addCoreMethodMapping((CharSequence)entry.getKey(), executableElement);
            }
            this.processMethodDeclarations(annotatedMethods);
            for (Map.Entry entry : annotatedMethods.entrySet()) {
                ExecutableElement executableElement = (ExecutableElement)((List)entry.getValue()).get(0);
                if (executableElement.getAnnotation(JRubyMethod.class).omit()) continue;
                this.addCoreMethodMapping((CharSequence)entry.getKey(), executableElement);
            }
            this.mv.voidreturn();
            this.mv.end();
            this.mv = new SkinnyMethodAdapter(cw, 9, "<clinit>", "()V", null, null);
            this.mv.start();
            if (frameAwareMethods != null && !frameAwareMethods.isEmpty()) {
                this.mv.ldc(frameAwareMethods.size());
                this.mv.anewarray("java/lang/String");
                int index2 = 0;
                for (CharSequence charSequence : frameAwareMethods) {
                    this.mv.dup();
                    this.mv.ldc(index2++);
                    this.mv.ldc(charSequence);
                    this.mv.aastore();
                }
                this.mv.invokestatic("org/jruby/runtime/MethodIndex", "addFrameAwareMethods", "([Ljava/lang/String;)V");
            }
            if (scopeAwareMethods != null && !scopeAwareMethods.isEmpty()) {
                this.mv.ldc(frameAwareMethods.size());
                this.mv.anewarray("java/lang/String");
                int index3 = 0;
                for (CharSequence charSequence : scopeAwareMethods) {
                    this.mv.dup();
                    this.mv.ldc(index3++);
                    this.mv.ldc(charSequence);
                    this.mv.aastore();
                }
                this.mv.invokestatic("org/jruby/runtime/MethodIndex", "addScopeAwareMethods", "([Ljava/lang/String;)V");
            }
            this.mv.voidreturn();
            this.mv.end();
            cw.visitEnd();
            new File(SRC_GEN_DIR).mkdirs();
            FileOutputStream fos = new FileOutputStream(SRC_GEN_DIR + qualifiedName + POPULATOR_SUFFIX + ".class");
            fos.write(cw.toByteArray());
            fos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void processMethodDeclarations(Map<CharSequence, List<ExecutableElement>> declarations) {
        for (Map.Entry<CharSequence, List<ExecutableElement>> entry : declarations.entrySet()) {
            List<ExecutableElement> list2 = entry.getValue();
            if (list2.size() == 1) {
                this.processMethodDeclaration(list2.get(0));
                continue;
            }
            this.processMethodDeclarationMulti(list2);
        }
    }

    public void processMethodDeclaration(ExecutableElement method) {
        this.processMethodDeclarationMulti(Arrays.asList(method));
    }

    public static long getEncodedSignature(JRubyMethod anno) {
        return IndyBinder.encodeSignature(anno.required(), anno.optional(), 0, 0, 0, anno.rest(), false);
    }

    public void processMethodDeclarationMulti(List<ExecutableElement> methods2) {
        Handle[] handles = new Handle[5];
        ArrayList<ExecutableElementDescriptor> descs = new ArrayList<ExecutableElementDescriptor>();
        boolean meta = false;
        boolean isStatic = false;
        JRubyMethod anno = null;
        int min2 = Integer.MAX_VALUE;
        int max2 = 0;
        HashMap<Handle, ExecutableElementDescriptor> handleToDesc = new HashMap<Handle, ExecutableElementDescriptor>();
        for (ExecutableElement method : methods2) {
            anno = method.getAnnotation(JRubyMethod.class);
            ExecutableElementDescriptor desc = new ExecutableElementDescriptor(method);
            descs.add(desc);
            if (anno == null || this.mv == null) continue;
            isStatic |= desc.isStatic;
            String qualifiedName = desc.declaringClassName;
            boolean hasContext = desc.hasContext;
            boolean hasBlock = desc.hasBlock;
            StringBuilder buffer = new StringBuilder(method.getReturnType().toString()).append(" foo(");
            boolean first2 = true;
            for (VariableElement variableElement : method.getParameters()) {
                if (!first2) {
                    buffer.append(',');
                }
                first2 = false;
                buffer.append(variableElement.asType().toString());
            }
            buffer.append(')');
            Handle handle = new Handle(isStatic ? 6 : 5, qualifiedName.toString().replace('.', '/'), method.getSimpleName().toString(), Method.getMethod(buffer.toString()).getDescriptor());
            int n = IndyBinder.calculateHandleOffset(method.getParameters().size(), anno.required(), anno.optional(), anno.rest(), isStatic, hasContext, hasBlock);
            handles[n] = handle;
            handleToDesc.put(handle, desc);
            meta |= anno.meta();
            int specificArity = -1;
            if (desc.optional == 0 && !desc.rest) {
                if (desc.required == 0) {
                    if (desc.actualRequired <= 3) {
                        specificArity = desc.actualRequired;
                    }
                } else if (desc.required >= 0 && desc.required <= 3) {
                    specificArity = desc.required;
                }
            }
            if (specificArity != -1) {
                if (specificArity < min2) {
                    min2 = specificArity;
                }
                if (specificArity <= max2) continue;
                max2 = specificArity;
                continue;
            }
            if (desc.required < min2) {
                min2 = desc.required;
            }
            if (desc.rest) {
                max2 = Integer.MAX_VALUE;
            }
            if (desc.required + desc.optional <= max2) continue;
            max2 = desc.required + desc.optional;
        }
        int implClass = meta ? 6 : 1;
        this.mv.newobj("org/jruby/internal/runtime/methods/HandleMethod");
        this.mv.dup();
        this.mv.aload(implClass);
        this.mv.getstatic(CodegenUtils.p(Visibility.class), anno.visibility().name(), CodegenUtils.ci(Visibility.class));
        this.mv.ldc(IndyBinder.encodeSignature(0, 0, 0, 0, 0, true, false));
        this.mv.ldc(true);
        this.mv.ldc(anno.notImplemented());
        DescriptorInfo info = new DescriptorInfo(descs);
        this.mv.ldc(info.getParameterDesc());
        this.mv.ldc(min2);
        this.mv.ldc(max2);
        for (int i2 = 0; i2 < 5; ++i2) {
            if (handles[i2] != null) {
                this.mv.ldc(handles[i2]);
                this.adaptHandle((ExecutableElementDescriptor)handleToDesc.get(handles[i2]), implClass);
                continue;
            }
            this.mv.aconst_null();
        }
        Method handleInit = Method.getMethod("void foo(org.jruby.RubyModule, org.jruby.runtime.Visibility, long, boolean, boolean, java.lang.String, int, int, java.util.concurrent.Callable, java.util.concurrent.Callable, java.util.concurrent.Callable, java.util.concurrent.Callable, java.util.concurrent.Callable)");
        this.mv.invokespecial("org/jruby/internal/runtime/methods/HandleMethod", "<init>", handleInit.getDescriptor());
        this.mv.astore(3);
        this.generateMethodAddCalls(methods2.get(0), anno);
    }

    public void adaptHandle(ExecutableElementDescriptor executableElementDescriptor, int implClass) {
        ExecutableElementDescriptor desc = executableElementDescriptor;
        this.mv.aload(5);
        this.mv.ldc(IndyBinder.calculateActualRequired(desc.method, desc.method.getParameters().size(), desc.optional, desc.rest, desc.isStatic, desc.hasContext, desc.hasBlock));
        this.mv.ldc(desc.required);
        this.mv.ldc(desc.optional);
        this.mv.ldc(desc.rest);
        this.mv.ldc(desc.rubyName);
        this.mv.ldc(Type.getObjectType(desc.declaringClassPath));
        this.mv.ldc(desc.isStatic);
        this.mv.ldc(desc.hasContext);
        this.mv.ldc(desc.hasBlock);
        this.mv.ldc(desc.anno.frame());
        this.mv.aload(implClass);
        this.mv.invokestatic("org/jruby/internal/runtime/methods/InvokeDynamicMethodFactory", "adaptHandle", Method.getMethod("java.util.concurrent.Callable adaptHandle(java.lang.invoke.MethodHandle, org.jruby.Ruby, int, int, int, boolean, java.lang.String, java.lang.Class, boolean, boolean, boolean, boolean, org.jruby.RubyModule)").getDescriptor());
    }

    private void addCoreMethodMapping(CharSequence rubyName, ExecutableElement decl) {
        this.mv.aload(5);
        this.mv.ldc(((TypeElement)decl.getEnclosingElement()).getQualifiedName().toString());
        this.mv.ldc(decl.getSimpleName().toString());
        this.mv.ldc(rubyName.toString());
        this.mv.invokevirtual("org/jruby/Ruby", "addBoundMethod", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
    }

    private static CharSequence getActualQualifiedName(TypeElement td) {
        if (td.getNestingKind() == NestingKind.MEMBER) {
            return IndyBinder.getActualQualifiedName((TypeElement)td.getEnclosingElement()) + "$" + td.getSimpleName();
        }
        return td.getQualifiedName().toString();
    }

    public static long encodeSignature(int pre, int opt, int post, int kwargs, int requiredKwargs, boolean rest2, boolean restKwargs) {
        return (long)pre << 41 | (long)opt << 33 | (long)post << 25 | (long)kwargs << 17 | (long)requiredKwargs << 9 | (long)((rest2 ? 1 : 0) << 1) | (long)((restKwargs ? 1 : 0) << 0);
    }

    private static int calculateActualRequired(ExecutableElement md, int paramsLength, int optional, boolean rest2, boolean isStatic, boolean hasContext, boolean hasBlock) {
        int actualRequired;
        if (optional == 0 && !rest2) {
            int args2 = paramsLength;
            if (args2 == 0) {
                actualRequired = 0;
            } else {
                if (isStatic) {
                    --args2;
                }
                if (hasContext) {
                    --args2;
                }
                if (hasBlock) {
                    --args2;
                }
                actualRequired = args2;
            }
        } else {
            int args3 = paramsLength;
            if (args3 == 0) {
                actualRequired = 0;
            } else {
                if (isStatic) {
                    --args3;
                }
                if (hasContext) {
                    --args3;
                }
                if (hasBlock) {
                    --args3;
                }
                actualRequired = --args3;
            }
            if (actualRequired != 0) {
                throw new RuntimeException("Combining specific args with IRubyObject[] is not yet supported: " + ((TypeElement)md.getEnclosingElement()).getQualifiedName() + "." + md.toString());
            }
        }
        return actualRequired;
    }

    private static int calculateHandleOffset(int paramsLength, int required, int optional, boolean rest2, boolean isStatic, boolean hasContext, boolean hasBlock) {
        if (required < 4 && optional == 0 && !rest2) {
            int args2 = paramsLength;
            if (args2 == 0) {
                return 0;
            }
            if (isStatic) {
                --args2;
            }
            if (hasContext) {
                --args2;
            }
            if (hasBlock) {
                --args2;
            }
            return args2;
        }
        return 4;
    }

    public void generateMethodAddCalls(ExecutableElement md, JRubyMethod jrubyMethod) {
        String[] names2 = jrubyMethod.name();
        String[] aliases2 = jrubyMethod.alias();
        if (jrubyMethod.meta()) {
            this.defineMethodOnClass(3, 6, names2, aliases2, md);
        } else {
            this.defineMethodOnClass(3, 1, names2, aliases2, md);
            if (jrubyMethod.module()) {
                this.mv.aload(1);
                this.mv.aload(3);
                this.mv.invokestatic("org/jruby/anno/TypePopulator", "populateModuleMethod", "(Lorg/jruby/RubyModule;Lorg/jruby/internal/runtime/methods/DynamicMethod;)Lorg/jruby/internal/runtime/methods/DynamicMethod;");
                this.mv.astore(4);
                this.defineMethodOnClass(4, 6, names2, aliases2, md);
            }
        }
    }

    private void defineMethodOnClass(int methodVar, int classVar, String[] names2, String[] aliases2, ExecutableElement md) {
        String baseName;
        if (names2.length == 0) {
            baseName = md.getSimpleName().toString();
            this.mv.aload(classVar);
            this.mv.ldc(baseName);
            this.mv.aload(methodVar);
            this.mv.invokevirtual("org/jruby/RubyModule", "addMethodAtBootTimeOnly", "(Ljava/lang/String;Lorg/jruby/internal/runtime/methods/DynamicMethod;)V");
        } else {
            baseName = names2[0];
            for (String name2 : names2) {
                this.mv.aload(classVar);
                this.mv.ldc(name2);
                this.mv.aload(methodVar);
                this.mv.invokevirtual("org/jruby/RubyModule", "addMethodAtBootTimeOnly", "(Ljava/lang/String;Lorg/jruby/internal/runtime/methods/DynamicMethod;)V");
            }
        }
        if (aliases2.length > 0) {
            for (String alias : aliases2) {
                this.mv.aload(classVar);
                this.mv.ldc(alias);
                this.mv.ldc(baseName);
                this.mv.invokevirtual("org/jruby/RubyModule", "defineAlias", "(Ljava/lang/String;Ljava/lang/String;)V");
            }
        }
    }
}

