/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Function;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.jffi.CallbackManager;
import org.jruby.ext.ffi.jffi.NativeCallbackFactory;
import org.jruby.ext.ffi.jffi.NativeCallbackPointer;
import org.jruby.ext.ffi.jffi.Signature;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class NativeInvoker
extends DynamicMethod {
    protected final Arity arity;
    protected final Function function;
    private final int cbIndex;
    private final NativeCallbackFactory cbFactory;
    private final Signature signature;

    public NativeInvoker(RubyModule implementationClass, Function function, Signature signature) {
        super(implementationClass, Visibility.PUBLIC);
        this.arity = Arity.fixed(signature.getParameterCount());
        this.function = function;
        this.signature = signature;
        int cbIndex = -1;
        NativeCallbackFactory cbFactory = null;
        for (int i2 = 0; i2 < signature.getParameterCount(); ++i2) {
            if (!(signature.getParameterType(i2) instanceof CallbackInfo)) continue;
            cbFactory = CallbackManager.getInstance().getCallbackFactory(implementationClass.getRuntime(), (CallbackInfo)signature.getParameterType(i2));
            cbIndex = i2;
            break;
        }
        this.cbIndex = cbIndex;
        this.cbFactory = cbFactory;
    }

    @Override
    public final DynamicMethod dup() {
        return this;
    }

    @Override
    public final Arity getArity() {
        return this.arity;
    }

    @Override
    public final boolean isNative() {
        return true;
    }

    Signature getSignature() {
        return this.signature;
    }

    CallContext getCallContext() {
        return this.function.getCallContext();
    }

    long getFunctionAddress() {
        return this.function.getFunctionAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        if (!block.isGiven() || this.cbIndex < 0) {
            this.arity.checkArity(context.runtime, args2);
            return this.call(context, self2, clazz, name2, args2);
        }
        Arity.checkArgumentCount(context.runtime, name2, args2, this.arity.getValue() - 1, this.arity.getValue());
        IRubyObject[] params2 = new IRubyObject[this.arity.getValue()];
        for (int i2 = 0; i2 < this.cbIndex; ++i2) {
            params2[i2] = args2[i2];
        }
        NativeCallbackPointer cb = this.cbFactory.newCallback(block);
        params2[this.cbIndex] = cb;
        for (int i3 = this.cbIndex + 1; i3 < params2.length; ++i3) {
            params2[i3] = args2[i3 - 1];
        }
        try {
            IRubyObject iRubyObject = this.call(context, self2, clazz, name2, params2);
            return iRubyObject;
        }
        finally {
            cb.dispose();
        }
    }
}

