/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jcodings.Encoding;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ThreadContext;

public class SymbolProc
extends ImmutableLiteral {
    private final String name;
    private final Encoding encoding;

    public SymbolProc(String name2, Encoding encoding2) {
        this.name = name2;
        this.encoding = encoding2;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.SYMBOL_PROC;
    }

    @Override
    public Object createCacheObject(ThreadContext context) {
        return IRRuntimeHelpers.newSymbolProc(context, this.name, this.encoding);
    }

    public int hashCode() {
        return 329 + (this.name.hashCode() ^ this.encoding.hashCode() >>> 32);
    }

    public boolean equals(Object other) {
        return other instanceof SymbolProc && this.name.equals(((SymbolProc)other).name) && this.encoding.equals(((SymbolProc)other).encoding);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.SymbolProc(this);
    }

    public String getName() {
        return this.name;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.name);
        e.encode(this.encoding);
    }

    public static SymbolProc decode(IRReaderDecoder d) {
        return new SymbolProc(d.decodeString(), d.decodeEncoding());
    }

    public String toString() {
        return "SymbolProc:" + this.name;
    }
}

