/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.platform.win32.COM.util.IComEnum;
import com.sun.jna.platform.win32.COM.util.ProxyObject;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;

public class Convert {
    public static Variant.VARIANT toVariant(Object value) {
        if (value instanceof Boolean) {
            return new Variant.VARIANT((Boolean)value);
        }
        if (value instanceof Long) {
            return new Variant.VARIANT(new WinDef.LONG((Long)value));
        }
        if (value instanceof Integer) {
            return new Variant.VARIANT((Integer)value);
        }
        if (value instanceof Short) {
            return new Variant.VARIANT(new WinDef.SHORT((long)((Short)value).shortValue()));
        }
        if (value instanceof Float) {
            return new Variant.VARIANT(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new Variant.VARIANT((Double)value);
        }
        if (value instanceof String) {
            return new Variant.VARIANT((String)value);
        }
        if (value instanceof Date) {
            return new Variant.VARIANT((Date)value);
        }
        if (value instanceof Proxy) {
            InvocationHandler ih = Proxy.getInvocationHandler(value);
            ProxyObject pobj = (ProxyObject)ih;
            return new Variant.VARIANT(pobj.getRawDispatch());
        }
        if (value instanceof IComEnum) {
            IComEnum enm = (IComEnum)value;
            return new Variant.VARIANT(new WinDef.LONG(enm.getValue()));
        }
        return null;
    }

    public static Object toJavaObject(Variant.VARIANT value) {
        if (null == value) {
            return null;
        }
        Object vobj = value.getValue();
        if (vobj instanceof WinDef.BOOL) {
            return ((WinDef.BOOL)vobj).booleanValue();
        }
        if (vobj instanceof WinDef.LONG) {
            return ((WinDef.LONG)vobj).longValue();
        }
        if (vobj instanceof WinDef.SHORT) {
            return ((WinDef.SHORT)vobj).shortValue();
        }
        if (vobj instanceof WinDef.UINT) {
            return ((WinDef.UINT)vobj).intValue();
        }
        if (vobj instanceof WinDef.WORD) {
            return ((WinDef.WORD)vobj).intValue();
        }
        if (vobj instanceof WTypes.BSTR) {
            return ((WTypes.BSTR)vobj).getValue();
        }
        return vobj;
    }

    public static <T extends IComEnum> T toComEnum(Class<T> enumType, Object value) {
        try {
            IComEnum[] values;
            Method m = enumType.getMethod("values", new Class[0]);
            for (IComEnum t : values = (IComEnum[])m.invoke(null, new Object[0])) {
                if (!value.equals(t.getValue())) continue;
                return (T)t;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }
}

