/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsModuleCheckUtilKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\u00042\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsModuleCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkReifieidTypeParameters", "call", "extractModuleCallee", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "js.frontend"})
public final class JsModuleCallChecker
implements CallChecker {
    public static final JsModuleCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.checkReifieidTypeParameters(resolvedCall2, reportOn, context);
        DeclarationDescriptor declarationDescriptor = this.extractModuleCallee(resolvedCall2);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor callee = declarationDescriptor;
        BindingContext bindingContext = context.getTrace().getBindingContext();
        DeclarationDescriptor containingDescriptor = context.getScope().getOwnerDescriptor();
        BindingContext bindingContext2 = bindingContext;
        Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "bindingContext");
        JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext2, context.getTrace(), containingDescriptor, callee, reportOn);
    }

    private final DeclarationDescriptor extractModuleCallee(ResolvedCall<?> call2) {
        Object callee = call2.getResultingDescriptor();
        if (DescriptorUtils.isTopLevelDeclaration((DeclarationDescriptor)callee)) {
            return (DeclarationDescriptor)callee;
        }
        ReceiverValue receiverValue = call2.getDispatchReceiver();
        if (receiverValue == null) {
            return (DeclarationDescriptor)callee;
        }
        ReceiverValue receiver = receiverValue;
        if (receiver instanceof ClassValueReceiver) {
            return ((ClassValueReceiver)receiver).getClassQualifier().getDescriptor();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReifieidTypeParameters(ResolvedCall<?> call2, PsiElement reportOn, CallCheckerContext context) {
        void $receiver$iv$iv;
        Map map2;
        Map map3;
        Iterable $receiver$iv;
        Object $$_$_param;
        TypeParameterDescriptor typeParameterDescriptor;
        Collection collection;
        Map $receiver$iv$iv2;
        Iterable $receiver$iv2;
        DeclarationDescriptor containingDescriptor = context.getScope().getOwnerDescriptor();
        Object obj = call2.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, "call.candidateDescriptor");
        List<TypeParameterDescriptor> list2 = obj.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "call.candidateDescriptor.typeParameters");
        Iterable iterable = $receiver$iv2 = (Iterable)list2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        Iterator<Object> iterator2 = $receiver$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv = iterator2.next();
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull(v2, "it");
            typeParameterDescriptor = v2.getOriginal();
            collection.add(typeParameterDescriptor);
        }
        $receiver$iv2 = CollectionsKt.withIndex((List)destination$iv$iv);
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv = new ArrayList();
        iterator2 = $receiver$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor param;
            Object element$iv$iv = iterator2.next();
            $$_$_param = (IndexedValue)element$iv$iv;
            TypeParameterDescriptor typeParameterDescriptor3 = param = (TypeParameterDescriptor)((IndexedValue)$$_$_param).component2();
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor3, "param");
            if (!typeParameterDescriptor3.isReified()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List typeParams = (List)destination$iv$iv;
        Call call3 = call2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call3, "call.call");
        KtTypeArgumentList ktTypeArgumentList = call3.getTypeArgumentList();
        if (ktTypeArgumentList != null) {
            void $receiver$iv$iv3;
            Map args = $receiver$iv$iv2 = ktTypeArgumentList;
            $receiver$iv = typeParams;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
            $$_$_param = $receiver$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            for (Object element$iv$iv : $receiver$iv$iv3) {
                TypeParameterDescriptor param;
                Map $i$f$filter = destination$iv$iv2;
                IndexedValue $index_param = (IndexedValue)element$iv$iv;
                int index2 = $index_param.component1();
                TypeParameterDescriptor typeParameterDescriptor4 = param = (TypeParameterDescriptor)$index_param.component2();
                Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor4, "param");
                TypeParameterDescriptor typeParameterDescriptor5 = typeParameterDescriptor4.getOriginal();
                Map map4 = args;
                Intrinsics.checkExpressionValueIsNotNull(map4, "args");
                KtTypeProjection ktTypeProjection = ((KtTypeArgumentList)((Object)map4)).getArguments().get(index2);
                Intrinsics.checkExpressionValueIsNotNull(ktTypeProjection, "args.arguments[index]");
                Pair<TypeParameterDescriptor, KtTypeReference> pair = TuplesKt.to(typeParameterDescriptor5, ktTypeProjection.getTypeReference());
                $i$f$filter.put(pair.getFirst(), pair.getSecond());
            }
            map3 = destination$iv$iv2;
        } else {
            map3 = null;
        }
        if ((map2 = ($receiver$iv$iv2 = map3)) == null) {
            map2 = MapsKt.emptyMap();
        }
        Map typeArguments2 = map2;
        Iterable capacity$iv = $receiver$iv = (Iterable)typeParams;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void $$_$_param2;
            TypeParameterDescriptor param;
            Object element$iv$iv;
            element$iv$iv = (IndexedValue)item$iv$iv;
            collection = destination$iv$iv3;
            TypeParameterDescriptor typeParameterDescriptor6 = param = (TypeParameterDescriptor)$$_$_param2.component2();
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor6, "param");
            typeParameterDescriptor = typeParameterDescriptor6.getOriginal();
            collection.add(typeParameterDescriptor);
        }
        for (TypeParameterDescriptor typeParam : (List)destination$iv$iv3) {
            ClassDescriptor typeArgumentClass;
            KotlinType typeArgument;
            PsiElement argPsi;
            KtTypeReference ktTypeReference = (KtTypeReference)typeArguments2.get(typeParam);
            PsiElement psiElement = argPsi = ktTypeReference != null ? (PsiElement)ktTypeReference : reportOn;
            if (call2.getTypeArguments().get(typeParam) == null) {
                continue;
            }
            ClassifierDescriptor classifierDescriptor = typeArgument.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            if ((ClassDescriptor)classifierDescriptor == null) {
                continue;
            }
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.bindingContext");
            JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext, context.getTrace(), containingDescriptor, typeArgumentClass, argPsi);
        }
    }

    private JsModuleCallChecker() {
    }

    static {
        JsModuleCallChecker jsModuleCallChecker;
        INSTANCE = jsModuleCallChecker = new JsModuleCallChecker();
    }
}

