# object.omit [![NPM version](https://badge.fury.io/js/object.omit.svg)](http://badge.fury.io/js/object.omit)

> Return a copy of an object excluding the given key, or array of keys. Also accepts an optional filter function as the last argument.

## Install

```sh
$ npm i object.omit --save-dev
```

## Usage

```js
var omit = require('object.omit');
```

Pass a string `key` to omit:

```js
omit({a: 'a', b: 'b', c: 'c'}, 'a')
//=> { b: 'b', c: 'c' }
```

Pass an array of `keys` to omit:

```js
omit({a: 'a', b: 'b', c: 'c'}, ['a', 'c'])
//=> { b: 'b' }
```

Returns the object if no keys are passed:

```js
omit({a: 'a', b: 'b', c: 'c'})
//=> {a: 'a', b: 'b', c: 'c'}
```

Returns an empty object if no value is passed.

```js
omit()
//=> {}
```

### Filter function

An optional filter function may be passed as the last argument, with or without keys passed on the arguments:

**filter on keys**

```js
var res = omit({a: 'a', b: 'b', c: 'c'}, function (val, key) {
  return key === 'a';
});
//=> {a: 'a'}
```

**filter on values**

```js
var fn = function() {};
var obj = {a: 'a', b: 'b', c: fn};

var res = omit(obj, ['a'], function (val, key) {
  return typeof val !== 'function';
});
//=> {b: 'b'}
```

### Other awesome javascript/node.js utils

* [object.filter](https://github.com/jonschlinkert/object.filter): Create a new object filtered to have only properties for which the callback returns true.
* [object.pick](https://github.com/jonschlinkert/object.pick): Returns a filtered copy of an object with only the specified keys, like `pick` from… [more](https://github.com/jonschlinkert/object.pick)
* [object.pluck](https://github.com/jonschlinkert/object.pluck): Like pluck from underscore / lo-dash, but returns an object composed of specified properties, with… [more](https://github.com/jonschlinkert/object.pluck)
* [object.reduce](https://github.com/jonschlinkert/object.reduce): Reduces an object to a value that is the accumulated result of running each property… [more](https://github.com/jonschlinkert/object.reduce)
* [object.defaults](https://github.com/jonschlinkert/object.defaults): Like `extend` but only copies missing properties/values to the target object.

## Runing tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/object.omit/issues/new)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2014-2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on July 22, 2015._