// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESData_IGESDumper_HeaderFile
#define _IGESData_IGESDumper_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_IGESData_IGESModel.hxx>
#include <IGESData_SpecificLib.hxx>
#include <Handle_IGESData_Protocol.hxx>
#include <Handle_IGESData_IGESEntity.hxx>
#include <Handle_Message_Messenger.hxx>
#include <Standard_Integer.hxx>
class IGESData_IGESModel;
class Interface_InterfaceError;
class IGESData_Protocol;
class IGESData_IGESEntity;
class Message_Messenger;


//! Provides a way to obtain a clear Dump of an IGESEntity
//! (distinct from normalized output). It works with tools
//! attached to Entities, as for normalized Reade and Write
//!
//! For each Entity, displaying data is splitted in own data
//! (specific to each type) and other attached data, which are
//! defined for all IGES Types (either from "Directory Entry" or
//! from Lists of Associativities and Properties)
class IGESData_IGESDumper 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Returns an IGESDumper ready to work. The IGESModel provides
  //! the numbering of Entities : as for any InterfaceModel, it
  //! gives each Entity a number; but for IGESEntities, the "Number
  //! of Directory Entry" according to the definition of IGES Files,
  //! is also usefull
  Standard_EXPORT IGESData_IGESDumper(const Handle(IGESData_IGESModel)& model, const Handle(IGESData_Protocol)& protocol);
  
  //! Prints onto an output, the "Number of Directory Entry" which
  //! corresponds to an IGESEntity in the IGESModel, under the form
  //! "D#nnn" (a Null Handle gives D#0)
  Standard_EXPORT   void PrintDNum (const Handle(IGESData_IGESEntity)& ent, const Handle(Message_Messenger)& S)  const;
  
  //! Prints onto an output, the "Number of Directory Entry" (see
  //! PrintDNum) plus IGES Type and Form Numbers, which gives
  //! "D#nnn  Type nnn  Form nnn"
  Standard_EXPORT   void PrintShort (const Handle(IGESData_IGESEntity)& ent, const Handle(Message_Messenger)& S)  const;
  
  Standard_EXPORT   void Dump (const Handle(IGESData_IGESEntity)& ent, const Handle(Message_Messenger)& S, const Standard_Integer own, const Standard_Integer attached = -1)  const;
  
  //! Specific Dump for each IGES Entity, call by Dump (just above)
  //! <own> is the parameter <own> from Dump
  Standard_EXPORT   void OwnDump (const Handle(IGESData_IGESEntity)& ent, const Handle(Message_Messenger)& S, const Standard_Integer own)  const;




protected:





private:



  Handle(IGESData_IGESModel) themodel;
  IGESData_SpecificLib thelib;


};







#endif // _IGESData_IGESDumper_HeaderFile
