/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.MethodParametersAttribute;
import proguard.classfile.attribute.ParameterInfo;
import proguard.classfile.attribute.annotation.TypeAnnotation;
import proguard.classfile.attribute.annotation.TypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.target.LocalVariableTargetElement;
import proguard.classfile.attribute.annotation.target.LocalVariableTargetInfo;
import proguard.classfile.attribute.annotation.target.TargetInfo;
import proguard.classfile.attribute.annotation.target.visitor.LocalVariableTargetElementVisitor;
import proguard.classfile.attribute.annotation.target.visitor.TargetInfoVisitor;
import proguard.classfile.attribute.annotation.visitor.TypeAnnotationVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class VariableRemapper
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
TypeAnnotationVisitor,
TargetInfoVisitor,
LocalVariableTargetElementVisitor {
    private static final boolean DEBUG = false;
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
    private int[] variableMap;

    public void setVariableMap(int[] nArray) {
        this.variableMap = nArray;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitMethodParametersAttribute(Clazz clazz, Method method, MethodParametersAttribute methodParametersAttribute) {
        ParameterInfo[] parameterInfoArray = methodParametersAttribute.parameters;
        ParameterInfo[] parameterInfoArray2 = new ParameterInfo[methodParametersAttribute.u1parametersCount];
        for (int i = 0; i < methodParametersAttribute.u1parametersCount; ++i) {
            parameterInfoArray2[this.remapVariable((int)i)] = parameterInfoArray[i];
        }
        methodParametersAttribute.parameters = parameterInfoArray2;
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitAnyTypeAnnotationsAttribute(Clazz clazz, TypeAnnotationsAttribute typeAnnotationsAttribute) {
        typeAnnotationsAttribute.typeAnnotationsAccept(clazz, this);
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.u2index = this.remapVariable(localVariableInfo.u2index);
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.u2index = this.remapVariable(localVariableTypeInfo.u2index);
    }

    @Override
    public void visitTypeAnnotation(Clazz clazz, TypeAnnotation typeAnnotation) {
        typeAnnotation.targetInfoAccept(clazz, this);
    }

    @Override
    public void visitAnyTargetInfo(Clazz clazz, TypeAnnotation typeAnnotation, TargetInfo targetInfo) {
    }

    @Override
    public void visitLocalVariableTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, LocalVariableTargetInfo localVariableTargetInfo) {
        localVariableTargetInfo.targetElementsAccept(clazz, method, codeAttribute, typeAnnotation, this);
    }

    @Override
    public void visitLocalVariableTargetElement(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, LocalVariableTargetInfo localVariableTargetInfo, LocalVariableTargetElement localVariableTargetElement) {
        localVariableTargetElement.u2index = this.remapVariable(localVariableTargetElement.u2index);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        int n2 = variableInstruction.variableIndex;
        int n3 = this.remapVariable(n2);
        if (n3 != n2) {
            VariableInstruction variableInstruction2 = new VariableInstruction(variableInstruction.opcode, n3, variableInstruction.constant);
            this.codeAttributeEditor.replaceInstruction(n, variableInstruction2);
        }
    }

    private int remapVariable(int n) {
        return this.variableMap[n];
    }
}

