/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class MemberToClassVisitor
implements MemberVisitor {
    private final ClassVisitor classVisitor;
    private Clazz lastVisitedClass;

    public MemberToClassVisitor(ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (!programClass.equals(this.lastVisitedClass)) {
            this.classVisitor.visitProgramClass(programClass);
            this.lastVisitedClass = programClass;
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (!programClass.equals(this.lastVisitedClass)) {
            this.classVisitor.visitProgramClass(programClass);
            this.lastVisitedClass = programClass;
        }
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (!libraryClass.equals(this.lastVisitedClass)) {
            this.classVisitor.visitLibraryClass(libraryClass);
            this.lastVisitedClass = libraryClass;
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (!libraryClass.equals(this.lastVisitedClass)) {
            this.classVisitor.visitLibraryClass(libraryClass);
            this.lastVisitedClass = libraryClass;
        }
    }
}

