/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorExAdapter;

public class ConvertEquivalentClassesToSuperClasses
extends AbstractCompositeOntologyChange {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLOntology targetOntology;
    @Nonnull
    private final OWLClass cls;
    @Nonnull
    private final Set<OWLOntology> ontologies;
    private final boolean splitIntersections;

    public ConvertEquivalentClassesToSuperClasses(@Nonnull OWLDataFactory dataFactory, @Nonnull OWLClass cls, @Nonnull Set<OWLOntology> ontologies, @Nonnull OWLOntology targetOntology, boolean splitIntersections) {
        super(dataFactory);
        this.targetOntology = OWLAPIPreconditions.checkNotNull(targetOntology, "targetOntology cannot be null");
        this.cls = OWLAPIPreconditions.checkNotNull(cls, "cls cannot be null");
        this.ontologies = OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
        this.splitIntersections = splitIntersections;
        this.generateChanges();
    }

    private void generateChanges() {
        HashSet<OWLClassExpression> supers = new HashSet<OWLClassExpression>();
        for (OWLOntology o : this.ontologies) {
            assert (o != null);
            for (OWLEquivalentClassesAxiom ax : o.getEquivalentClassesAxioms(this.cls)) {
                assert (ax != null);
                this.addChange(new RemoveAxiom(o, ax));
                for (OWLClassExpression equivCls : ax.getClassExpressions()) {
                    assert (equivCls != null);
                    supers.addAll(this.getClassExpressions(equivCls));
                }
            }
        }
        supers.remove(this.cls);
        for (OWLClassExpression sup : supers) {
            assert (sup != null);
            this.addChange(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLSubClassOfAxiom(this.cls, sup)));
        }
    }

    @Nonnull
    private Set<OWLClassExpression> getClassExpressions(@Nonnull OWLClassExpression desc) {
        Set<OWLClassExpression> result;
        if (this.splitIntersections && (result = desc.accept(new OWLClassExpressionVisitorExAdapter<Set<OWLClassExpression>>(CollectionFactory.emptySet()){

            @Override
            public Set<OWLClassExpression> visit(OWLObjectIntersectionOf ce) {
                return ce.getOperands();
            }
        })).isEmpty()) {
            result.add(desc);
        }
        return CollectionFactory.createSet(desc);
    }
}

