/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import javax.annotation.Nonnull;
import org.semanticweb.owlapi.rdf.rdfxml.parser.AbstractState;
import org.semanticweb.owlapi.rdf.rdfxml.parser.EmptyPropertyElement;
import org.semanticweb.owlapi.rdf.rdfxml.parser.NodeElement;
import org.semanticweb.owlapi.rdf.rdfxml.parser.ParseTypeCollectionElement;
import org.semanticweb.owlapi.rdf.rdfxml.parser.ParseTypeLiteralElement;
import org.semanticweb.owlapi.rdf.rdfxml.parser.ParseTypeResourceElement;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.semanticweb.owlapi.rdf.rdfxml.parser.ResourceOrLiteralElement;
import org.semanticweb.owlapi.rdf.rdfxml.parser.State;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class PropertyElementList
extends AbstractState
implements State {
    @Nonnull
    protected final NodeElement node;

    PropertyElementList(@Nonnull NodeElement nodeElement, @Nonnull RDFParser parser) {
        super(parser);
        this.node = nodeElement;
    }

    @Override
    public void startElement(String namespaceIRI, String localName, String qName, @Nonnull Attributes atts) throws SAXException {
        String parseType = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType");
        if ("Literal".equals(parseType) || "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral".equals(atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype"))) {
            this.parser.pushState(new ParseTypeLiteralElement(this.node, this.parser));
        } else if ("Resource".equals(parseType)) {
            this.parser.pushState(new ParseTypeResourceElement(this.node, this.parser));
        } else if ("Collection".equals(parseType)) {
            this.parser.pushState(new ParseTypeCollectionElement(this.node, this.parser));
        } else if (parseType != null) {
            this.parser.pushState(new ParseTypeLiteralElement(this.node, this.parser));
        } else {
            String objectIRI = this.getNodeIDResourceResourceIRI(atts);
            if (objectIRI != null) {
                this.parser.pushState(new EmptyPropertyElement(this.node, this.parser));
            } else {
                this.parser.pushState(new ResourceOrLiteralElement(this.node, this.parser));
            }
        }
        this.parser.state.startElement(namespaceIRI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceIRI, String localName, String qName) throws SAXException {
        this.parser.popState();
        this.parser.state.endElement(namespaceIRI, localName, qName);
    }

    @Override
    public void characters(char[] data, int start, int length) {
        this.parser.verify(this.notBlank(data, start, length), "Cannot answer characters when object properties are expected.");
    }
}

