/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.impl;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public final class NodeFactory {
    private NodeFactory() {
    }

    @Nonnull
    public static DefaultNode<OWLClass> getOWLClassNode() {
        return new OWLClassNode();
    }

    @Nonnull
    public static DefaultNode<OWLClass> getOWLClassNode(@Nonnull OWLClass cls) {
        return new OWLClassNode(OWLAPIPreconditions.checkNotNull(cls, "cls cannot be null"));
    }

    @Nonnull
    public static DefaultNode<OWLClass> getOWLClassNode(@Nonnull Set<OWLClass> clses) {
        return new OWLClassNode(OWLAPIPreconditions.checkNotNull(clses, "clses cannot be null"));
    }

    public static DefaultNode<OWLClass> getOWLClassTopNode() {
        return OWLClassNode.getTopNode();
    }

    public static DefaultNode<OWLClass> getOWLClassBottomNode() {
        return OWLClassNode.getBottomNode();
    }

    @Nonnull
    public static DefaultNode<OWLObjectPropertyExpression> getOWLObjectPropertyNode() {
        return new OWLObjectPropertyNode();
    }

    @Nonnull
    public static DefaultNode<OWLObjectPropertyExpression> getOWLObjectPropertyNode(@Nonnull OWLObjectPropertyExpression prop) {
        return new OWLObjectPropertyNode(prop);
    }

    @Nonnull
    public static DefaultNode<OWLObjectPropertyExpression> getOWLObjectPropertyNode(@Nonnull Set<OWLObjectPropertyExpression> properties) {
        return new OWLObjectPropertyNode(properties);
    }

    public static DefaultNode<OWLObjectPropertyExpression> getOWLObjectPropertyTopNode() {
        return OWLObjectPropertyNode.getTopNode();
    }

    public static DefaultNode<OWLObjectPropertyExpression> getOWLObjectPropertyBottomNode() {
        return OWLObjectPropertyNode.getBottomNode();
    }

    @Nonnull
    public static DefaultNode<OWLDataProperty> getOWLDataPropertyNode() {
        return new OWLDataPropertyNode();
    }

    @Nonnull
    public static DefaultNode<OWLDataProperty> getOWLDataPropertyNode(@Nonnull OWLDataProperty prop) {
        return new OWLDataPropertyNode(prop);
    }

    @Nonnull
    public static DefaultNode<OWLDataProperty> getOWLDataPropertyNode(@Nonnull Set<OWLDataProperty> properties) {
        return new OWLDataPropertyNode(properties);
    }

    public static DefaultNode<OWLDataProperty> getOWLDataPropertyTopNode() {
        return OWLDataPropertyNode.getTopNode();
    }

    public static DefaultNode<OWLDataProperty> getOWLDataPropertyBottomNode() {
        return OWLDataPropertyNode.getBottomNode();
    }

    @Nonnull
    public static DefaultNode<OWLNamedIndividual> getOWLNamedIndividualNode() {
        return new OWLNamedIndividualNode();
    }

    @Nonnull
    public static DefaultNode<OWLNamedIndividual> getOWLNamedIndividualNode(@Nonnull OWLNamedIndividual ind) {
        return new OWLNamedIndividualNode(ind);
    }

    @Nonnull
    public static DefaultNode<OWLNamedIndividual> getOWLNamedIndividualNode(@Nonnull Set<OWLNamedIndividual> inds) {
        return new OWLNamedIndividualNode(inds);
    }
}

