/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapitools.builders.BaseBuilder;

public class BuilderLiteral
extends BaseBuilder<OWLLiteral, BuilderLiteral> {
    @Nullable
    private String lang = null;
    @Nullable
    private String literalForm = null;
    @Nullable
    private Integer intValue = null;
    @Nullable
    private Double doubleValue = null;
    @Nullable
    private Float floatValue = null;
    @Nullable
    private Boolean booleanValue = null;
    @Nullable
    private OWLDatatype datatype;

    public BuilderLiteral(@Nonnull OWLLiteral expected, OWLDataFactory df) {
        this(df);
        this.withDatatype(expected.getDatatype()).withLanguage(expected.getLang());
        if (expected.isBoolean()) {
            this.withValue(expected.parseBoolean());
        } else if (expected.isDouble()) {
            this.withValue(expected.parseDouble());
        } else if (expected.isFloat()) {
            this.withValue(expected.parseFloat());
        } else if (expected.isInteger()) {
            this.withValue(expected.parseInteger());
        } else {
            this.withLiteralForm(expected.getLiteral());
        }
    }

    @Inject
    public BuilderLiteral(OWLDataFactory df) {
        super(df);
    }

    protected void clear() {
        this.literalForm = null;
        this.intValue = null;
        this.doubleValue = null;
        this.floatValue = null;
        this.booleanValue = null;
    }

    @Nonnull
    public BuilderLiteral withValue(int arg) {
        this.clear();
        this.intValue = arg;
        return this;
    }

    @Nonnull
    public BuilderLiteral withDatatype(@Nonnull OWL2Datatype arg) {
        return this.withDatatype(this.df.getOWLDatatype(arg.getIRI()));
    }

    @Nonnull
    public BuilderLiteral withDatatype(OWLDatatype arg) {
        this.lang = null;
        this.datatype = arg;
        return this;
    }

    @Nonnull
    public BuilderLiteral withValue(boolean arg) {
        this.clear();
        this.booleanValue = arg;
        return this;
    }

    @Nonnull
    public BuilderLiteral withValue(double arg) {
        this.clear();
        this.doubleValue = arg;
        return this;
    }

    @Nonnull
    public BuilderLiteral withValue(float arg) {
        this.clear();
        this.floatValue = Float.valueOf(arg);
        return this;
    }

    @Nonnull
    public BuilderLiteral withLiteralForm(String arg) {
        this.clear();
        this.literalForm = arg;
        return this;
    }

    @Nonnull
    public BuilderLiteral withLanguage(String arg) {
        this.datatype = null;
        this.lang = arg;
        return this;
    }

    @Override
    public OWLLiteral buildObject() {
        if (this.intValue != null) {
            return this.df.getOWLLiteral(this.intValue);
        }
        if (this.doubleValue != null) {
            return this.df.getOWLLiteral(this.doubleValue);
        }
        if (this.floatValue != null) {
            return this.df.getOWLLiteral(this.floatValue.floatValue());
        }
        if (this.booleanValue != null) {
            return this.df.getOWLLiteral(this.booleanValue);
        }
        if (this.lang != null) {
            return this.df.getOWLLiteral(this.literalForm, this.lang);
        }
        return this.df.getOWLLiteral(this.literalForm, this.datatype);
    }
}

