/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import org.apache.ivy.ant.IvyAntSettings;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;

public class IvyConfigure
extends Task {
    public static final String OVERRIDE_TRUE = "true";
    public static final String OVERRIDE_FALSE = "false";
    public static final String OVERRIDE_NOT_ALLOWED = "notallowed";
    private static final Collection OVERRIDE_VALUES = Arrays.asList("true", "false", "notallowed");
    private String override = "notallowed";
    private IvyAntSettings settings = new IvyAntSettings();

    public void setSettingsId(String string) {
        this.settings.setId(string);
    }

    public String getSettingsId() {
        return this.settings.getId();
    }

    public void setOverride(String string) {
        if (!OVERRIDE_VALUES.contains(string)) {
            throw new IllegalArgumentException("invalid override value '" + string + "'. " + "Valid values are " + OVERRIDE_VALUES);
        }
        this.override = string;
    }

    public String getOverride() {
        return this.override;
    }

    public File getFile() {
        return this.settings.getFile();
    }

    public void setFile(File file) {
        this.settings.setFile(file);
    }

    public URL getUrl() {
        return this.settings.getUrl();
    }

    public void setUrl(String string) throws MalformedURLException {
        this.settings.setUrl(string);
    }

    public void setUrl(URL uRL) {
        if (uRL == null) {
            throw new NullPointerException("Cannot set a null URL");
        }
        this.settings.setUrl(uRL);
    }

    public String getRealm() {
        return this.settings.getRealm();
    }

    public void setRealm(String string) {
        this.settings.setRealm(string);
    }

    public String getHost() {
        return this.settings.getHost();
    }

    public void setHost(String string) {
        this.settings.setHost(string);
    }

    public String getUserName() {
        return this.settings.getUsername();
    }

    public void setUserName(String string) {
        this.settings.setUsername(string);
    }

    public String getPasswd() {
        return this.settings.getPasswd();
    }

    public void setPasswd(String string) {
        this.settings.setPasswd(string);
    }

    public void execute() throws BuildException {
        String string = this.settings.getId();
        Object object = this.getProject().getReference(string);
        if (object != null && OVERRIDE_NOT_ALLOWED.equals(this.override)) {
            throw new BuildException("Overriding a previous definition of ivy:settings with the id '" + string + "' is not allowed when using override='" + OVERRIDE_NOT_ALLOWED + "'.");
        }
        if (object != null && OVERRIDE_FALSE.equals(this.override)) {
            this.verbose("A settings definition is already available for " + string + ": skipping");
            return;
        }
        this.settings.setProject(this.getProject());
        this.getProject().addReference(string, (Object)this.settings);
        this.settings.createIvyEngine((ProjectComponent)this);
    }

    private void verbose(String string) {
        this.log(string, 3);
    }
}

