/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.sort.ModuleDescriptorSorter;
import org.apache.ivy.core.sort.SortEngineSettings;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.circular.CircularDependencyException;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.circular.IgnoreCircularDependencyStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Checks;

public class SortEngine {
    private SortEngineSettings settings;

    public SortEngine(SortEngineSettings sortEngineSettings) {
        if (sortEngineSettings == null) {
            throw new NullPointerException("SortEngine.settings can not be null");
        }
        this.settings = sortEngineSettings;
    }

    public List sortNodes(Collection collection, SortOptions sortOptions) {
        LinkedHashMap<ModuleDescriptor, ArrayList<IvyNode>> linkedHashMap = new LinkedHashMap<ModuleDescriptor, ArrayList<IvyNode>>();
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        for (IvyNode ivyNode : collection) {
            if (ivyNode.getDescriptor() == null) {
                arrayList.add(ivyNode);
                continue;
            }
            ArrayList<IvyNode> arrayList2 = (ArrayList<IvyNode>)linkedHashMap.get(ivyNode.getDescriptor());
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<IvyNode>();
                linkedHashMap.put(ivyNode.getDescriptor(), arrayList2);
            }
            arrayList2.add(ivyNode);
        }
        List list = this.sortModuleDescriptors(linkedHashMap.keySet(), sortOptions);
        ArrayList<IvyNode> arrayList3 = new ArrayList<IvyNode>((int)((double)list.size() * 1.3 + (double)arrayList.size()));
        for (int i = 0; i < list.size(); ++i) {
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)list.get(i);
            List list2 = (List)linkedHashMap.get(moduleDescriptor);
            arrayList3.addAll(list2);
        }
        arrayList3.addAll(0, arrayList);
        return arrayList3;
    }

    public List sortModuleDescriptors(Collection collection, SortOptions sortOptions) throws CircularDependencyException {
        Checks.checkNotNull(sortOptions, "options");
        ModuleDescriptorSorter moduleDescriptorSorter = new ModuleDescriptorSorter(collection, this.getVersionMatcher(), sortOptions.getNonMatchingVersionReporter(), sortOptions.isUseCircularDependencyStrategy() ? this.getCircularStrategy() : IgnoreCircularDependencyStrategy.getInstance());
        return moduleDescriptorSorter.sortModuleDescriptors();
    }

    protected CircularDependencyStrategy getCircularStrategy() {
        return this.settings.getCircularDependencyStrategy();
    }

    protected VersionMatcher getVersionMatcher() {
        return this.settings.getVersionMatcher();
    }
}

