/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.descriptor.OverrideDependencyDescriptorMediator;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.m2.DefaultPomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomReader;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;

public class PomModuleDescriptorBuilder {
    private static final int DEPENDENCY_MANAGEMENT_KEY_PARTS_COUNT = 4;
    public static final Configuration[] MAVEN2_CONFIGURATIONS = new Configuration[]{new Configuration("default", Configuration.Visibility.PUBLIC, "runtime dependencies and master artifact can be used with this conf", new String[]{"runtime", "master"}, true, null), new Configuration("master", Configuration.Visibility.PUBLIC, "contains only the artifact published by this module itself, with no transitive dependencies", new String[0], true, null), new Configuration("compile", Configuration.Visibility.PUBLIC, "this is the default scope, used if none is specified. Compile dependencies are available in all classpaths.", new String[0], true, null), new Configuration("provided", Configuration.Visibility.PUBLIC, "this is much like compile, but indicates you expect the JDK or a container to provide it. It is only available on the compilation classpath, and is not transitive.", new String[0], true, null), new Configuration("runtime", Configuration.Visibility.PUBLIC, "this scope indicates that the dependency is not required for compilation, but is for execution. It is in the runtime and test classpaths, but not the compile classpath.", new String[]{"compile"}, true, null), new Configuration("test", Configuration.Visibility.PRIVATE, "this scope indicates that the dependency is not required for normal use of the application, and is only available for the test compilation and execution phases.", new String[]{"runtime"}, true, null), new Configuration("system", Configuration.Visibility.PUBLIC, "this scope is similar to provided except that you have to provide the JAR which contains it explicitly. The artifact is always available and is not looked up in a repository.", new String[0], true, null), new Configuration("sources", Configuration.Visibility.PUBLIC, "this configuration contains the source artifact of this module, if any.", new String[0], true, null), new Configuration("javadoc", Configuration.Visibility.PUBLIC, "this configuration contains the javadoc artifact of this module, if any.", new String[0], true, null), new Configuration("optional", Configuration.Visibility.PUBLIC, "contains all optional dependencies", new String[0], true, null)};
    static final Map MAVEN2_CONF_MAPPING = new HashMap();
    private static final String DEPENDENCY_MANAGEMENT = "m:dependency.management";
    private static final String PROPERTIES = "m:properties";
    private static final String EXTRA_INFO_DELIMITER = "__";
    private static final Collection JAR_PACKAGINGS = Arrays.asList("ejb", "bundle", "maven-plugin", "eclipse-plugin", "jbi-component", "jbi-shared-library", "orbit", "hk2-jar");
    private final PomModuleDescriptor ivyModuleDescriptor;
    private ModuleRevisionId mrid;
    private DefaultArtifact mainArtifact;
    private ParserSettings parserSettings;
    private static final String WRONG_NUMBER_OF_PARTS_MSG = "what seemed to be a dependency management extra info exclusion had the wrong number of parts (should have 2) ";

    public PomModuleDescriptorBuilder(ModuleDescriptorParser moduleDescriptorParser, Resource resource, ParserSettings parserSettings) {
        this.ivyModuleDescriptor = new PomModuleDescriptor(moduleDescriptorParser, resource);
        this.ivyModuleDescriptor.setResolvedPublicationDate(new Date(resource.getLastModified()));
        for (int i = 0; i < MAVEN2_CONFIGURATIONS.length; ++i) {
            this.ivyModuleDescriptor.addConfiguration(MAVEN2_CONFIGURATIONS[i]);
        }
        this.ivyModuleDescriptor.setMappingOverride(true);
        this.ivyModuleDescriptor.addExtraAttributeNamespace("m", Ivy.getIvyHomeURL() + "maven");
        this.parserSettings = parserSettings;
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.ivyModuleDescriptor;
    }

    public void setModuleRevId(String string, String string2, String string3) {
        this.mrid = ModuleRevisionId.newInstance(string, string2, string3);
        this.ivyModuleDescriptor.setModuleRevisionId(this.mrid);
        if (string3 == null || string3.endsWith("SNAPSHOT")) {
            this.ivyModuleDescriptor.setStatus("integration");
        } else {
            this.ivyModuleDescriptor.setStatus("release");
        }
    }

    public void setHomePage(String string) {
        this.ivyModuleDescriptor.setHomePage(string);
    }

    public void setDescription(String string) {
        this.ivyModuleDescriptor.setDescription(string);
    }

    public void setLicenses(License[] licenseArray) {
        for (int i = 0; i < licenseArray.length; ++i) {
            this.ivyModuleDescriptor.addLicense(licenseArray[i]);
        }
    }

    public void addMainArtifact(String string, String string2) {
        if ("pom".equals(string2)) {
            DefaultArtifact defaultArtifact;
            ArtifactOrigin artifactOrigin;
            DependencyResolver dependencyResolver = this.parserSettings.getResolver(this.mrid);
            if (dependencyResolver != null && !ArtifactOrigin.isUnknown(artifactOrigin = dependencyResolver.locate(defaultArtifact = new DefaultArtifact(this.mrid, new Date(), string, "jar", "jar")))) {
                this.mainArtifact = defaultArtifact;
                this.ivyModuleDescriptor.addArtifact("master", this.mainArtifact);
            }
            return;
        }
        String string3 = JAR_PACKAGINGS.contains(string2) ? "jar" : ("pear".equals(string2) ? "phar" : string2);
        this.mainArtifact = new DefaultArtifact(this.mrid, new Date(), string, string2, string3);
        this.ivyModuleDescriptor.addArtifact("master", this.mainArtifact);
    }

    public void addDependency(Resource resource, PomReader.PomDependencyData pomDependencyData) {
        Object object;
        String string;
        String string2 = pomDependencyData.getScope();
        if (string2 != null && string2.length() > 0 && !MAVEN2_CONF_MAPPING.containsKey(string2)) {
            string2 = "compile";
        }
        string = (string = pomDependencyData.getVersion()) == null || string.length() == 0 ? this.getDefaultVersion(pomDependencyData) : string;
        ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(pomDependencyData.getGroupId(), pomDependencyData.getArtifactId(), string);
        ModuleRevisionId moduleRevisionId2 = this.ivyModuleDescriptor.getModuleRevisionId();
        if (moduleRevisionId2 != null && moduleRevisionId2.getModuleId().equals(moduleRevisionId.getModuleId())) {
            return;
        }
        List list = pomDependencyData.getExcludedModules();
        Boolean bl = !this.containsExcludeAllElement(list);
        PomDependencyDescriptor pomDependencyDescriptor = new PomDependencyDescriptor(pomDependencyData, this.ivyModuleDescriptor, moduleRevisionId, bl);
        string2 = string2 == null || string2.length() == 0 ? this.getDefaultScope(pomDependencyData) : string2;
        ConfMapper confMapper = (ConfMapper)MAVEN2_CONF_MAPPING.get(string2);
        confMapper.addMappingConfs(pomDependencyDescriptor, pomDependencyData.isOptional());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (pomDependencyData.getClassifier() != null || pomDependencyData.getType() != null && !"jar".equals(pomDependencyData.getType())) {
            Object object2 = "jar";
            if (pomDependencyData.getType() != null) {
                object2 = pomDependencyData.getType();
            }
            Object object3 = object2;
            if ("test-jar".equals(object2)) {
                object3 = "jar";
                hashMap.put("m:classifier", "tests");
            } else if (JAR_PACKAGINGS.contains(object2)) {
                object3 = "jar";
            }
            if (pomDependencyData.getClassifier() != null) {
                hashMap.put("m:classifier", pomDependencyData.getClassifier());
            }
            object = new DefaultDependencyArtifactDescriptor(pomDependencyDescriptor, pomDependencyDescriptor.getDependencyId().getName(), (String)object2, (String)object3, null, hashMap);
            String string3 = pomDependencyData.isOptional() ? "optional" : string2;
            pomDependencyDescriptor.addDependencyArtifact(string3, (DependencyArtifactDescriptor)object);
        }
        if (list.isEmpty()) {
            list = PomModuleDescriptorBuilder.getDependencyMgtExclusions(this.ivyModuleDescriptor, pomDependencyData.getGroupId(), pomDependencyData.getArtifactId());
        }
        if (bl.booleanValue()) {
            for (Object object3 : list) {
                object = pomDependencyDescriptor.getModuleConfigurations();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    pomDependencyDescriptor.addExcludeRule(object[i], new DefaultExcludeRule(new ArtifactId((ModuleId)object3, "*", "*", "*"), ExactPatternMatcher.INSTANCE, null));
                }
            }
        }
        this.ivyModuleDescriptor.addDependency(pomDependencyDescriptor);
    }

    public void addDependency(DependencyDescriptor dependencyDescriptor) {
        ModuleId moduleId = dependencyDescriptor.getDependencyId();
        ModuleRevisionId moduleRevisionId = this.ivyModuleDescriptor.getModuleRevisionId();
        if (moduleRevisionId != null && moduleRevisionId.getModuleId().equals(moduleId)) {
            return;
        }
        this.ivyModuleDescriptor.addDependency(dependencyDescriptor);
    }

    public void addDependencyMgt(PomDependencyMgt pomDependencyMgt) {
        String string;
        this.ivyModuleDescriptor.addDependencyManagement(pomDependencyMgt);
        String string2 = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForVersion(pomDependencyMgt.getGroupId(), pomDependencyMgt.getArtifactId());
        this.ivyModuleDescriptor.addExtraInfo(string2, pomDependencyMgt.getVersion());
        if (pomDependencyMgt.getScope() != null) {
            string = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForScope(pomDependencyMgt.getGroupId(), pomDependencyMgt.getArtifactId());
            this.ivyModuleDescriptor.addExtraInfo(string, pomDependencyMgt.getScope());
        }
        if (!pomDependencyMgt.getExcludedModules().isEmpty()) {
            string = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoPrefixForExclusion(pomDependencyMgt.getGroupId(), pomDependencyMgt.getArtifactId());
            int n = 0;
            for (ModuleId moduleId : pomDependencyMgt.getExcludedModules()) {
                this.ivyModuleDescriptor.addExtraInfo(string + n, moduleId.getOrganisation() + EXTRA_INFO_DELIMITER + moduleId.getName());
                ++n;
            }
        }
        this.ivyModuleDescriptor.addDependencyDescriptorMediator(ModuleId.newInstance(pomDependencyMgt.getGroupId(), pomDependencyMgt.getArtifactId()), ExactPatternMatcher.INSTANCE, new OverrideDependencyDescriptorMediator(null, pomDependencyMgt.getVersion()));
    }

    public void addPlugin(PomDependencyMgt pomDependencyMgt) {
        String string = pomDependencyMgt.getGroupId() + EXTRA_INFO_DELIMITER + pomDependencyMgt.getArtifactId() + EXTRA_INFO_DELIMITER + pomDependencyMgt.getVersion();
        String string2 = (String)this.ivyModuleDescriptor.getExtraInfo().get("m:maven.plugins");
        string2 = string2 == null ? string : string2 + "|" + string;
        this.ivyModuleDescriptor.getExtraInfo().put("m:maven.plugins", string2);
    }

    public static List getPlugins(ModuleDescriptor moduleDescriptor) {
        ArrayList<PomPluginElement> arrayList = new ArrayList<PomPluginElement>();
        String string = (String)moduleDescriptor.getExtraInfo().get("m:maven.plugins");
        if (string == null) {
            return new ArrayList();
        }
        String[] stringArray = string.split("\\|");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(EXTRA_INFO_DELIMITER);
            arrayList.add(new PomPluginElement(stringArray2[0], stringArray2[1], stringArray2[2]));
        }
        return arrayList;
    }

    private boolean containsExcludeAllElement(List list) {
        for (ModuleId moduleId : list) {
            if (!moduleId.getOrganisation().equals("*") || !moduleId.getName().equals("*")) continue;
            return true;
        }
        return false;
    }

    private String getDefaultVersion(PomReader.PomDependencyData pomDependencyData) {
        ModuleId moduleId = ModuleId.newInstance(pomDependencyData.getGroupId(), pomDependencyData.getArtifactId());
        if (this.ivyModuleDescriptor.getDependencyManagementMap().containsKey(moduleId)) {
            return ((PomDependencyMgt)this.ivyModuleDescriptor.getDependencyManagementMap().get(moduleId)).getVersion();
        }
        String string = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForVersion(pomDependencyData.getGroupId(), pomDependencyData.getArtifactId());
        return (String)this.ivyModuleDescriptor.getExtraInfo().get(string);
    }

    private String getDefaultScope(PomReader.PomDependencyData pomDependencyData) {
        String string;
        ModuleId moduleId = ModuleId.newInstance(pomDependencyData.getGroupId(), pomDependencyData.getArtifactId());
        if (this.ivyModuleDescriptor.getDependencyManagementMap().containsKey(moduleId)) {
            string = ((PomDependencyMgt)this.ivyModuleDescriptor.getDependencyManagementMap().get(moduleId)).getScope();
        } else {
            String string2 = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForScope(pomDependencyData.getGroupId(), pomDependencyData.getArtifactId());
            string = (String)this.ivyModuleDescriptor.getExtraInfo().get(string2);
        }
        if (string == null || !MAVEN2_CONF_MAPPING.containsKey(string)) {
            string = "compile";
        }
        return string;
    }

    private static String getDependencyMgtExtraInfoKeyForVersion(String string, String string2) {
        return "m:dependency.management__" + string + EXTRA_INFO_DELIMITER + string2 + EXTRA_INFO_DELIMITER + "version";
    }

    private static String getDependencyMgtExtraInfoKeyForScope(String string, String string2) {
        return "m:dependency.management__" + string + EXTRA_INFO_DELIMITER + string2 + EXTRA_INFO_DELIMITER + "scope";
    }

    private static String getPropertyExtraInfoKey(String string) {
        return "m:properties__" + string;
    }

    private static String getDependencyMgtExtraInfoPrefixForExclusion(String string, String string2) {
        return "m:dependency.management__" + string + EXTRA_INFO_DELIMITER + string2 + EXTRA_INFO_DELIMITER + "exclusion_";
    }

    private static List getDependencyMgtExclusions(ModuleDescriptor moduleDescriptor, String string, String string2) {
        Object object;
        if (moduleDescriptor instanceof PomModuleDescriptor && (object = (PomDependencyMgt)((PomModuleDescriptor)moduleDescriptor).getDependencyManagementMap().get(ModuleId.newInstance(string, string2))) != null) {
            return object.getExcludedModules();
        }
        object = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoPrefixForExclusion(string, string2);
        LinkedList<ModuleId> linkedList = new LinkedList<ModuleId>();
        Map map = moduleDescriptor.getExtraInfo();
        for (Map.Entry entry : map.entrySet()) {
            String string3 = (String)entry.getKey();
            if (!string3.startsWith((String)object)) continue;
            String string4 = (String)entry.getValue();
            String[] stringArray = string4.split(EXTRA_INFO_DELIMITER);
            if (stringArray.length != 2) {
                Message.error(WRONG_NUMBER_OF_PARTS_MSG + stringArray.length + " : " + string4);
                continue;
            }
            linkedList.add(ModuleId.newInstance(stringArray[0], stringArray[1]));
        }
        return linkedList;
    }

    public static Map getDependencyManagementMap(ModuleDescriptor moduleDescriptor) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        if (moduleDescriptor instanceof PomModuleDescriptor) {
            for (Map.Entry entry : ((PomModuleDescriptor)moduleDescriptor).getDependencyManagementMap().entrySet()) {
                PomDependencyMgt pomDependencyMgt = (PomDependencyMgt)entry.getValue();
                linkedHashMap.put(entry.getKey(), pomDependencyMgt.getVersion());
            }
        } else {
            for (Map.Entry entry : moduleDescriptor.getExtraInfo().entrySet()) {
                String string = (String)entry.getKey();
                if (!string.startsWith(DEPENDENCY_MANAGEMENT)) continue;
                String[] stringArray = string.split(EXTRA_INFO_DELIMITER);
                if (stringArray.length != 4) {
                    Message.warn("what seem to be a dependency management extra info doesn't match expected pattern: " + string);
                    continue;
                }
                linkedHashMap.put(ModuleId.newInstance(stringArray[1], stringArray[2]), (String)entry.getValue());
            }
        }
        return linkedHashMap;
    }

    public static List getDependencyManagements(ModuleDescriptor moduleDescriptor) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (moduleDescriptor instanceof PomModuleDescriptor) {
            arrayList.addAll(((PomModuleDescriptor)moduleDescriptor).getDependencyManagementMap().values());
        } else {
            for (Map.Entry entry : moduleDescriptor.getExtraInfo().entrySet()) {
                String string = (String)entry.getKey();
                if (!string.startsWith(DEPENDENCY_MANAGEMENT)) continue;
                String[] stringArray = string.split(EXTRA_INFO_DELIMITER);
                if (stringArray.length != 4) {
                    Message.warn("what seem to be a dependency management extra info doesn't match expected pattern: " + string);
                    continue;
                }
                String string2 = "m:dependency.management__" + stringArray[1] + EXTRA_INFO_DELIMITER + stringArray[2] + EXTRA_INFO_DELIMITER + "version";
                String string3 = "m:dependency.management__" + stringArray[1] + EXTRA_INFO_DELIMITER + stringArray[2] + EXTRA_INFO_DELIMITER + "scope";
                String string4 = (String)moduleDescriptor.getExtraInfo().get(string2);
                String string5 = (String)moduleDescriptor.getExtraInfo().get(string3);
                List list = PomModuleDescriptorBuilder.getDependencyMgtExclusions(moduleDescriptor, stringArray[1], stringArray[2]);
                arrayList.add(new DefaultPomDependencyMgt(stringArray[1], stringArray[2], string4, string5, list));
            }
        }
        return arrayList;
    }

    public void addExtraInfos(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            this.addExtraInfo(string, string2);
        }
    }

    private void addExtraInfo(String string, String string2) {
        if (!this.ivyModuleDescriptor.getExtraInfo().containsKey(string)) {
            this.ivyModuleDescriptor.addExtraInfo(string, string2);
        }
    }

    public static Map extractPomProperties(Map map) {
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith(PROPERTIES)) continue;
            String string = ((String)entry.getKey()).substring(PROPERTIES.length() + EXTRA_INFO_DELIMITER.length());
            hashMap.put(string, entry.getValue());
        }
        return hashMap;
    }

    public void addProperty(String string, String string2) {
        this.addExtraInfo(PomModuleDescriptorBuilder.getPropertyExtraInfoKey(string), string2);
    }

    public Artifact getMainArtifact() {
        return this.mainArtifact;
    }

    public Artifact getSourceArtifact() {
        return new MDArtifact(this.ivyModuleDescriptor, this.mrid.getName(), "source", "jar", null, Collections.singletonMap("m:classifier", "sources"));
    }

    public Artifact getSrcArtifact() {
        return new MDArtifact(this.ivyModuleDescriptor, this.mrid.getName(), "source", "jar", null, Collections.singletonMap("m:classifier", "src"));
    }

    public Artifact getJavadocArtifact() {
        return new MDArtifact(this.ivyModuleDescriptor, this.mrid.getName(), "javadoc", "jar", null, Collections.singletonMap("m:classifier", "javadoc"));
    }

    public void addSourceArtifact() {
        this.ivyModuleDescriptor.addArtifact("sources", this.getSourceArtifact());
    }

    public void addSrcArtifact() {
        this.ivyModuleDescriptor.addArtifact("sources", this.getSrcArtifact());
    }

    public void addJavadocArtifact() {
        this.ivyModuleDescriptor.addArtifact("javadoc", this.getJavadocArtifact());
    }

    static {
        MAVEN2_CONF_MAPPING.put("compile", new ConfMapper(){

            @Override
            public void addMappingConfs(DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
                if (bl) {
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "compile(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "master(*)");
                } else {
                    defaultDependencyDescriptor.addDependencyConfiguration("compile", "compile(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("compile", "master(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("runtime", "runtime(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("provided", new ConfMapper(){

            @Override
            public void addMappingConfs(DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
                if (bl) {
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "compile(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "provided(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "runtime(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "master(*)");
                } else {
                    defaultDependencyDescriptor.addDependencyConfiguration("provided", "compile(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("provided", "provided(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("provided", "runtime(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("provided", "master(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("runtime", new ConfMapper(){

            @Override
            public void addMappingConfs(DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
                if (bl) {
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "compile(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "provided(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "master(*)");
                } else {
                    defaultDependencyDescriptor.addDependencyConfiguration("runtime", "compile(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("runtime", "runtime(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("runtime", "master(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("test", new ConfMapper(){

            @Override
            public void addMappingConfs(DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
                defaultDependencyDescriptor.addDependencyConfiguration("test", "runtime(*)");
                defaultDependencyDescriptor.addDependencyConfiguration("test", "master(*)");
            }
        });
        MAVEN2_CONF_MAPPING.put("system", new ConfMapper(){

            @Override
            public void addMappingConfs(DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
                defaultDependencyDescriptor.addDependencyConfiguration("system", "master(*)");
            }
        });
    }

    public static class PomModuleDescriptor
    extends DefaultModuleDescriptor {
        private final Map dependencyManagementMap = new HashMap();

        public PomModuleDescriptor(ModuleDescriptorParser moduleDescriptorParser, Resource resource) {
            super(moduleDescriptorParser, resource);
        }

        public void addDependencyManagement(PomDependencyMgt pomDependencyMgt) {
            this.dependencyManagementMap.put(ModuleId.newInstance(pomDependencyMgt.getGroupId(), pomDependencyMgt.getArtifactId()), pomDependencyMgt);
        }

        public Map getDependencyManagementMap() {
            return this.dependencyManagementMap;
        }
    }

    public static class PomDependencyDescriptor
    extends DefaultDependencyDescriptor {
        private final PomReader.PomDependencyData pomDependencyData;

        private PomDependencyDescriptor(PomReader.PomDependencyData pomDependencyData, ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId, Boolean bl) {
            super(moduleDescriptor, moduleRevisionId, true, false, bl);
            this.pomDependencyData = pomDependencyData;
        }

        public PomReader.PomDependencyData getPomDependencyData() {
            return this.pomDependencyData;
        }
    }

    private static class PomPluginElement
    implements PomDependencyMgt {
        private String groupId;
        private String artifactId;
        private String version;

        public PomPluginElement(String string, String string2, String string3) {
            this.groupId = string;
            this.artifactId = string2;
            this.version = string3;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getArtifactId() {
            return this.artifactId;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getScope() {
            return null;
        }

        @Override
        public List getExcludedModules() {
            return Collections.EMPTY_LIST;
        }
    }

    static interface ConfMapper {
        public void addMappingConfs(DefaultDependencyDescriptor var1, boolean var2);
    }
}

