/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository;

import org.apache.ivy.plugins.repository.Resource;

public abstract class LazyResource
implements Resource {
    private boolean init = false;
    private boolean local;
    private String name;
    private long lastModified;
    private long contentLength;
    private boolean exists;

    public LazyResource(String string) {
        this.name = string;
    }

    protected abstract void init();

    private void checkInit() {
        if (!this.init) {
            this.init();
            this.init = true;
        }
    }

    @Override
    public boolean exists() {
        this.checkInit();
        return this.exists;
    }

    @Override
    public long getContentLength() {
        this.checkInit();
        return this.contentLength;
    }

    @Override
    public long getLastModified() {
        this.checkInit();
        return this.lastModified;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isLocal() {
        this.checkInit();
        return this.local;
    }

    public String toString() {
        return this.getName();
    }

    protected void setContentLength(long l) {
        this.contentLength = l;
    }

    protected void setExists(boolean bl) {
        this.exists = bl;
    }

    protected void setLastModified(long l) {
        this.lastModified = l;
    }

    protected void setLocal(boolean bl) {
        this.local = bl;
    }

    protected void init(Resource resource) {
        this.setContentLength(resource.getContentLength());
        this.setLocal(resource.isLocal());
        this.setLastModified(resource.getLastModified());
        this.setExists(resource.exists());
    }
}

